import getpass
import json
import requests

TOKEN_ENDPOINT = (
    "https://auth.app.tora.com/auth/realms/TORA/protocol/openid-connect/token"
)
CLIENT_IDS = {
    "prod": "oems-wsgw-prod",
    "uat": "oems-wsgw-uat",
    "demo": "oems-wsgw-demo",
    "srm": "srm",
    "desktop-uat": "auth-desktop-uat",
    "desktop-prod": "auth-desktop-prod",
}


def main():
    env = input("environment (uat, prod, srm, demo): ")
    if env not in CLIENT_IDS:
        print("please choose from uat, prod, srm, demo")
        return

    user = input("user (email address): ")
    password = getpass.getpass()
    otp = input("totp (google authenticator): ")
    data = {
        "client_id": CLIENT_IDS[env],
        "grant_type": "password",
        "scope": "openid offline_access",
        "username": user,
        "password": password,
        "totp": otp,
    }
    r = requests.post(TOKEN_ENDPOINT, data=data).json()
    if "error" in r:
        print(json.dumps(r, indent=4))
    if "refresh_token" in r:
        is_create_file = input("Would you like to write token in the file? (y/n): ")
        if is_create_file.lower() in ["y", "yes"]:
            print("")
            try:
                with open("oemsws_refresh_token.txt", "x") as outfile:
                    outfile.write(r["refresh_token"])
                    print(
                        " refresh token is stored in your current path with oemsws_refresh_token.txt"
                    )
            except FileExistsError:
                print(
                    "Failed to create oemsws_refresh_token.txt. File already exists in the current directory"
                )
        else:
            print(f'refresh token: {r["refresh_token"]}')


if __name__ == "__main__":
    main()
