import sys
import uuid

sys.path.append("../oemsws")

from samples import _log
from oemsws.api import API
from samples.keycloak.config import (
    API_ENDPOINT,
    TOKEN_ENDPOINT,
    CLIENT_ID,
    USER,
    GROUP,
)

_log.setup()


def main():
    # Create an API instance and open a connection.
    with API.create_persistence(
        API_ENDPOINT,
        TOKEN_ENDPOINT,
        CLIENT_ID,
        GROUP,
        USER,
    ) as api:
        print("registering and sending a pair order...")

        params = {
            "algoId": str(uuid.uuid4()),
            "broker": "tpairs",
            "strategy": "Pairs",
            "algoFields": {
                "Strategy": "Pairs",
                "Version": "4.2.8",
                "check_available_liquidity": "true",
                "continuous": "true",
                "conversion": "None",
                "incremental_float": "false",
                "leg1_concurrency": "2",
                "leg1_enable_passive_pov": "false",
                "leg1_enable_pov": "false",
                "leg1_executing_broker": "gs",
                "leg1_execution_style": "AGGRESSIVE",
                "leg1_instrument": "9432.T",
                "leg1_pov_type": "None",
                "leg1_primary": "true",
                "leg1_slice_manual": "100.0",
                "leg1_slippage": "0.0",
                "leg1_threshold": "1.0",
                "leg2_concurrency": "2",
                "leg2_enable_passive_pov": "false",
                "leg2_enable_pov": "false",
                "leg2_executing_broker": "baml",
                "leg2_execution_style": "AGGRESSIVE",
                "leg2_instrument": "6501.T",
                "leg2_pov_type": "None",
                "leg2_primary": "false",
                "leg2_slice_manual": "100.0",
                "leg2_slippage": "0.0",
                "leg2_threshold": "1.0",
                "leg_strategy": "AD_FLOAT_FIX",
                "pairs_alert_action_type": "CROSS",
                "pairs_ord_status": "ACTIVE",
                "slippage_percent_type": "true",
                "target_ratio": "0.58903275",
                "target_spread": "0.0",
            },
            "orders": [
                {
                    "legName": "leg1",
                    "clientOrderId": str(uuid.uuid4()),
                    "symbol": "9432.T",
                    "symbolType": "reuters",
                    "quantity": 500.0,
                    "side": "BUY",
                    "limitPrice": 0.0,
                    "broker": "tpairs",
                    "flowType": "ALGO",
                    "brokerAccount": "TestAccount1",
                    "condition": "WORKED",
                    "workBrkSpecStrategy": "Pairs",
                    "orderType": "TPAIRS_ATDL",
                },
                {
                    "legName": "leg2",
                    "clientOrderId": str(uuid.uuid4()),
                    "symbol": "6501.T",
                    "symbolType": "reuters",
                    "broker": "tpairs",
                    "side": "SELL",
                    "quantity": 500.0,
                    "limitPrice": 0.0,
                    "flowType": "ALGO",
                    "brokerAccount": "TestAccount1",
                    "condition": "WORKED",
                    "workBrkSpecStrategy": "Pairs",
                    "orderType": "TPAIRS_ATDL",
                },
            ],
        }

        # register pair order
        response = api.pair_service.register(params)

        order_ids = [resp["orderId"] for resp in response["orders"]]
        leg_names = [resp["legName"] for resp in response["orders"]]

        print("ordersIds....", order_ids)

        print("cancelling pair....")

        api.pair_service.cancel(
            {
                "orders": [
                    {"orderId": order_ids[0], "legName": leg_names[0]},
                    {"orderId": order_ids[1], "legName": leg_names[1]},
                ]
            }
        )

        print("pair cancelled....")

        input("Hit enter to stop...\n")

    # The end of `with` statement closes the connection
    print("Connection closed.")


if __name__ == "__main__":
    main()
