import sys
import uuid
import time

from samples import _log
from oemsws.api import API
from samples.keycloak.config import (
    API_ENDPOINT,
    TOKEN_ENDPOINT,
    CLIENT_ID,
    USER,
    GROUP,
)

sys.path.append("../oemsws")
_log.setup()


def main():
    # Create an API instance and open a connection.
    with API.create_persistence(
        API_ENDPOINT,
        TOKEN_ENDPOINT,
        CLIENT_ID,
        GROUP,
        USER,
    ) as api:

        cl_ord_id_1 = str(uuid.uuid4())
        cl_ord_id_2 = str(uuid.uuid4())

        response = api.order_service.register(
            {
                "order": {
                    "clientOrderId": cl_ord_id_1,
                    "symbol": "0005.HK",
                    "symbolType": "reuters",
                    "quantity": "10000",
                    "side": "BUY",
                    "limitPrice": "0.0",
                    "brokerAccount": "TestAccount1",
                    "broker": "tpairs",
                    "condition": "NORMAL",
                },
            }
        )

        order_id_1 = response["orderId"]

        print(f"registered first order with orderId: {order_id_1}")

        response = api.order_service.register(
            {
                "order": {
                    "clientOrderId": cl_ord_id_2,
                    "symbol": "0001.HK",
                    "symbolType": "reuters",
                    "quantity": "19000",
                    "side": "SELL",
                    "limitPrice": "0.0",
                    "brokerAccount": "TestAccount1",
                    "broker": "tpair",
                    "condition": "NORMAL",
                },
            }
        )

        order_id_2 = response["orderId"]
        print(f"registered second order with orderId: {order_id_2}")

        time.sleep(3)

        print("pairing up orders....")

        params = {
            "algoId": str(uuid.uuid4()),
            "strategy": "Pairs",
            "broker": "tpairs",
            "Strategy": "Pairs",
            "algoFields": {
                "target_ratio": "15.65",
                "pairs_ord_status": "INACTIVE",
                "target_spread": 0.0,
                "conversion": "None",
                "pairs_alert_action_type": "CROSS",
                "leg1_threshold": 0.01,
                "leg2_threshold": 0.01,
                "leg1_slippage": 0,
                "leg2_slippage": 0,
                "leg1_concurrency": 1,
                "leg2_concurrency": 1,
                "leg1_slice_manual": 400,
                "leg2_slice_manual": 500,
                "leg_strategy": "AD_FLOAT_FIX",
                "leg1_instrument": "0005.HK",
                "leg2_instrument": "0001.HK",
                "leg1_primary": "Y",
                "leg2_primary": "N",
                "leg1_pov_type": "ALL",
                "leg2_pov_type": "ALL",
                "leg1_execution_style": "AGGRESSIVE",
                "leg2_execution_style": "AGGRESSIVE",
                "leg1_pov": 10,
                "leg2_pov": 10,
                "leg1_executing_broker": "baml",
                "leg2_executing_broker": "baml",
            },
            "orders": [
                {
                    "orderId": order_id_1,  # orderID or clientOrderId required
                    "legName": "leg1",  # legName is required
                },
                {
                    "orderId": order_id_2,  # orderID or clientOrderId required
                    "legName": "leg2",  # legName is required
                },
            ],
        }

        # register pair order
        response = api.pair_service.pair_up(params)

        order_ids = [resp["orderId"] for resp in response["orders"]]
        leg_names = [resp["legName"] for resp in response["orders"]]

        print("response....", order_ids)

        # send pair order
        api.pair_service.send(
            {
                "orders": [
                    {"orderId": order_ids[0], "legName": leg_names[0]},
                    {"orderId": order_ids[1], "legName": leg_names[1]},
                ]
            }
        )
        print("pair sent....")

        print(response)

        input("Hit enter to stop...\n")

    # The end of `with` statement closes the connection
    print("Connection closed.")


if __name__ == "__main__":
    main()
