import sys
import uuid

sys.path.append("../../../oemsws")

from samples import _log
from oemsws.api import API
from samples.keycloak.config import (
    API_ENDPOINT,
    TOKEN_ENDPOINT,
    CLIENT_ID,
    USER,
    GROUP,
)

_log.setup()


def main():
    leg_1_data = {
        "order": {
            "clientOrderId": str(uuid.uuid4()),
            "symbol": "2503.T",
            "symbolType": "reuters",
            "quantity": 1400.0,
            "side": "BUY",
            "limitPrice": 0.0,
            "broker": "tpairs",
            "flowType": "ALGO",
            "brokerAccount": "TestAccount1",
            "condition": "WORKED",
            "workBrkSpecStrategy": "Pairs",
            "orderType": "TPAIRS_ATDL",
            "workATDLDescription": "Strategy:Pairs;Version:4.3.5;target_spread:0.0;target_ratio:0.589023;tgtbt_check"
            ":true;secondary_avg_price:N/A;primary_avg_price:N/A;pair_session_info_tag:N/A"
            ";pair_executed_conversion_rate:N/A;pair_error_reason:N/A;active_cover_count:N/A"
            ";pairs_is_hung:N/A;leg2_instrument:2503.T;leg1_instrument:2502.T"
            ";enable_too_good_to_be_true:false;leg2_threshold:1.0;leg1_threshold:1.0"
            ";leg_strategy:AD_FLOAT_FIX;leg2_slippage:0.0;leg1_slippage:0.0"
            ";slippage_percent_type:true;enable_flexible_slice_sizes:false;leg2_concurrency:2"
            ";leg1_concurrency:2;enable_slices:false;leg2_slice_manual:100.0;leg1_slice_manual"
            ":100.0;leg2_primary:false;leg1_primary:true;leg2_enable_passive_pov:false"
            ";leg2_enable_pov:false;leg1_enable_passive_pov:false;leg1_enable_pov:false"
            ";leg2_pov_type:None;leg1_pov_type:None;pairs_ord_status:ACTIVE;incremental_float"
            ":false;conversion:None;leg2_execution_style:AGGRESSIVE;leg1_execution_style"
            ":AGGRESSIVE;leg2_executing_broker:baml;leg1_executing_broker:gs;continuous:false"
            ";check_available_liquidity:false;pairs_alert_action_type:CROSS",
            "workBrkSpecATDL": "8500:Pairs;7621:4.3.5;6004:0.0;6003:0.589023;6067:Y;8178:N/A;8078:N/A;8076:N/A;8075:N"
            "/A;8043:N/A;8042:N/A;8041:N/A;6101:2503.T;6001:2502.T;6068:N;6109:1.0;6009:1.0;6000"
            ":AD_FLOAT_FIX;6108:0.0;6008:0.0;6014:Y;8107:N;6111:2;6011:2;6028:N;6107:100.0;6007"
            ":100.0;6115:N;6015:Y;6197:N;6199:N;6097:N;6099:N;6196:NONE;6096:NONE;6041:ACTIVE;8056"
            ":N;6005:NONE;6110:AGGRESSIVE;6010:AGGRESSIVE;6117:baml;6017:gs;8057:N;8053:N;6040"
            ":CROSS;",
        },
    }

    leg_2_data = {
        "order": {
            "clientOrderId": str(uuid.uuid4()),
            "symbol": "2502.T",
            "symbolType": "reuters",
            "broker": "tpairs",
            "side": "SELL",
            "quantity": 600.0,
            "limitPrice": 0.0,
            "flowType": "ALGO",
            "brokerAccount": "TestAccount1",
            "condition": "WORKED",
            "workBrkSpecStrategy": "Pairs",
            "orderType": "TPAIRS_ATDL",
            "workATDLDescription": "Strategy:Pairs;Version:4.3.5;target_spread:0.0;target_ratio:0.589023;tgtbt_check"
            ":true;secondary_avg_price:N/A;primary_avg_price:N/A;pair_session_info_tag:N/A"
            ";pair_executed_conversion_rate:N/A;pair_error_reason:N/A;active_cover_count:N/A"
            ";pairs_is_hung:N/A;leg2_instrument:2503.T;leg1_instrument:2502.T"
            ";enable_too_good_to_be_true:false;leg2_threshold:1.0;leg1_threshold:1.0"
            ";leg_strategy:AD_FLOAT_FIX;leg2_slippage:0.0;leg1_slippage:0.0"
            ";slippage_percent_type:true;enable_flexible_slice_sizes:false;leg2_concurrency:2"
            ";leg1_concurrency:2;enable_slices:false;leg2_slice_manual:100.0;leg1_slice_manual"
            ":100.0;leg2_primary:false;leg1_primary:true;leg2_enable_passive_pov:false"
            ";leg2_enable_pov:false;leg1_enable_passive_pov:false;leg1_enable_pov:false"
            ";leg2_pov_type:None;leg1_pov_type:None;pairs_ord_status:ACTIVE;incremental_float"
            ":false;conversion:None;leg2_execution_style:AGGRESSIVE;leg1_execution_style"
            ":AGGRESSIVE;leg2_executing_broker:baml;leg1_executing_broker:gs;continuous:false"
            ";check_available_liquidity:false;pairs_alert_action_type:CROSS",
            "workBrkSpecATDL": "8500:Pairs;7621:4.3.5;6004:0.0;6003:0.589023;6067:Y;8178:N/A;8078:N/A;8076:N/A;8075:N"
            "/A;8043:N/A;8042:N/A;8041:N/A;6101:2503.T;6001:2502.T;6068:N;6109:1.0;6009:1.0;6000"
            ":AD_FLOAT_FIX;6108:0.0;6008:0.0;6014:Y;8107:N;6111:2;6011:2;6028:N;6107:100.0;6007"
            ":100.0;6115:N;6015:Y;6197:N;6199:N;6097:N;6099:N;6196:NONE;6096:NONE;6041:ACTIVE;8056"
            ":N;6005:NONE;6110:AGGRESSIVE;6010:AGGRESSIVE;6117:baml;6017:gs;8057:N;8053:N;6040"
            ":CROSS;",
        }
    }

    # Create an API instance and open a connection.
    with API.create_persistence(
        API_ENDPOINT,
        TOKEN_ENDPOINT,
        CLIENT_ID,
        GROUP,
        USER,
    ) as api:
        print("registering a pair order...")

        # register pair order
        response = api.order_service.register_native_atdl_pair(leg_1_data, leg_2_data)

        print("RESPONSE....", response)

        input("Hit enter to stop...\n")

    # The end of `with` statement closes the connection
    print("Connection closed.")


if __name__ == "__main__":
    main()
