import sys
import uuid

sys.path.append("../../../oemsws")

from samples import _log
from oemsws.api import API
from samples.keycloak.config import (
    API_ENDPOINT,
    TOKEN_ENDPOINT,
    CLIENT_ID,
    USER,
    GROUP,
)

_log.setup()


def main():
    # Create an API instance and open a connection.
    symbol_list = ["7203.T", "6758.T"]

    # Create an API instance and open a connection.
    with API.create_persistence(
        API_ENDPOINT,
        TOKEN_ENDPOINT,
        CLIENT_ID,
        GROUP,
        USER,
    ) as api:
        # create list of 2 order object
        orders = [
            {
                "order": {
                    "clientOrderId": str(uuid.uuid4()),
                    "symbol": symbol,
                    "symbolType": "reuters",
                    "quantity": 100,
                    "side": "BUY",
                    "limitPrice": 0.0,
                    "brokerAccount": "abc",
                    "broker": "ml",
                    "condition": "WORKED",
                    "orderType": "CD",
                }
            }
            for symbol in symbol_list
        ]
        order_ids = api.order_service.batch(orders, action="register")
        print(f"Registered order with orderIds: {order_ids}")

        input("Hit enter to cancel...\n")

        print("Canceling the order...")
        orders_to_cancel = [{"orderId": v["orderId"]} for v in order_ids]
        res = api.order_service.batch(orders_to_cancel, action="cancel")
        print("Cancelled order", res)

        input("Hit enter to stop...\n")

    # The end of `with` statement closes the connection
    print("Connection closed.")


if __name__ == "__main__":
    main()
