import sys
import uuid

sys.path.append("../../../oemsws")

from samples import _log
from oemsws.api import API
from samples.keycloak.config import (
    API_ENDPOINT,
    TOKEN_ENDPOINT,
    CLIENT_ID,
    USER,
    GROUP,
)

_log.setup()


def main():
    # Create an API instance and open a connection.
    with API.create_persistence(
        API_ENDPOINT,
        TOKEN_ENDPOINT,
        CLIENT_ID,
        GROUP,
        USER,
    ) as api:
        print("Registering an order...")

        cl_ord_id = str(uuid.uuid4())
        response = api.order_service.register(
            {
                "order": {
                    "clientOrderId": cl_ord_id,
                    "symbol": "7203.T",
                    "symbolType": "reuters",
                    "quantity": "100",
                    "side": "BUY",
                    "limitPrice": 0.0,
                    "brokerAccount": "abc",
                    "broker": "baml",
                    "condition": "NORMAL",
                    "orderType": "MARKET",
                }
            }
        )

        order_id = response["orderId"]

        print(f"Registered order with orderId: {order_id}")

        print("Amending the order...")

        api.order_service.amend(
            {
                "order": {
                    "clientOrderId": cl_ord_id,
                    "symbol": "7203.T",
                    "symbolType": "reuters",
                    "quantity": "200",
                    "side": "BUY",
                    "limitPrice": 0.0,
                    "brokerAccount": "abc",
                    "broker": "baml",
                    "condition": "NORMAL",
                    "orderType": "MARKET",
                }
            }
        )

        print("Amended order")

        print("Canceling the order...")

        api.order_service.cancel(
            {
                "clientOrderId": cl_ord_id,
            }
        )

        print("Cancelled order")

        input("Hit enter to stop...\n")

    # The end of `with` statement closes the connection
    print("Connection closed.")


if __name__ == "__main__":
    main()
