import sys
import uuid

sys.path.append("../../../oemsws")

from samples import _log
from oemsws.api import API
from samples.keycloak.config import (
    API_ENDPOINT,
    TOKEN_ENDPOINT,
    CLIENT_ID,
    USER,
    GROUP,
)

_log.setup()


def main():
    # Create an API instance and open a connection.
    with API.create_persistence(
        API_ENDPOINT,
        TOKEN_ENDPOINT,
        CLIENT_ID,
        GROUP,
        USER,
    ) as api:

        print("Registering a parent order...")

        cl_ord_id = str(uuid.uuid4())
        response = api.order_service.register(
            {
                "order": {
                    "clientOrderId": cl_ord_id,
                    "symbol": "7203.T",
                    "symbolType": "reuters",
                    "quantity": "100",
                    "side": "BUY",
                    "limitPrice": "0.0",
                    "brokerAccount": "TestAccount1",
                    "broker": "ms",
                }
            }
        )

        order_id = response["orderId"]

        print(f"Registered parent order with orderId: {order_id}")

        print("Sending the parent order...")

        api.order_service.send({"clientOrderId": cl_ord_id})

        print("Registering another parent order...")

        parent_cl_ord_id = str(uuid.uuid4())
        response = api.order_service.register(
            {
                "order": {
                    "clientOrderId": parent_cl_ord_id,
                    "symbol": "9201.T",
                    "symbolType": "reuters",
                    "quantity": "100",
                    "side": "BUY",
                    "limitPrice": "0.0",
                    "brokerAccount": "TestAccount1",
                    "broker": "ms",
                }
            }
        )

        parent_order_id = response["orderId"]

        print(f"Registered another parent order with orderId: {parent_order_id}")

        print("Registering a child order under the parent...")

        cl_ord_id = str(uuid.uuid4())
        api.order_service.register(
            {
                "order": {
                    "clientOrderId": cl_ord_id,
                    "symbol": "9201.T",
                    "symbolType": "reuters",
                    "quantity": "100",
                    "side": "BUY",
                    "limitPrice": "0.0",
                    "brokerAccount": "TestAccount1",
                    "broker": "ms",
                    "parentId": parent_order_id,
                }
            }
        )

        print("Amending a child order under the parent...")

        api.order_service.amend(
            {
                "order": {
                    "clientOrderId": cl_ord_id,
                    "symbol": "9201.T",
                    "symbolType": "reuters",
                    "quantity": "100",
                    "side": "BUY",
                    "limitPrice": "0.0",
                    "brokerAccount": "TestAccount1",
                    "broker": "ms",
                    "parentId": parent_order_id,
                }
            }
        )

        print("Sending the child order...")

        api.order_service.send({"clientOrderId": cl_ord_id})

        print("Register and send a child order under the parent...")

        cl_ord_id = str(uuid.uuid4())
        api.order_service.register_and_send(
            {
                "order": {
                    "clientOrderId": cl_ord_id,
                    "symbol": "9201.T",
                    "symbolType": "reuters",
                    "quantity": "100",
                    "side": "BUY",
                    "limitPrice": "0.0",
                    "brokerAccount": "TestAccount1",
                    "broker": "ms",
                    "parentId": parent_order_id,
                }
            }
        )

        input("Hit enter to stop...\n")

    # The end of `with` statement closes the connection
    print("Connection closed.")


if __name__ == "__main__":
    main()
