import random
import sys
import time
import uuid
from threading import Thread

sys.path.append("../../../oemsws")

from samples import _log
from oemsws.api import API
from samples.keycloak.config import (
    API_ENDPOINT,
    TOKEN_ENDPOINT,
    CLIENT_ID,
    USER,
    GROUP,
)

_log.setup()


def register_order(api: API) -> str:
    cl_ord_id = str(uuid.uuid4())
    print("Registering an order...")
    response = api.order_service.register(
        {
            "order": {
                "clientOrderId": cl_ord_id,
                "symbol": "7203.T",
                "symbolType": "reuters",
                "quantity": "100",
                "side": "BUY",
                "limitPrice": "0.0",
                "brokerAccount": "abc",
                "broker": "ms",
            }
        }
    )
    order_id = response["orderId"]
    print(f"Registered order with orderId: {order_id}")
    return cl_ord_id


def amend_order(api: API, cl_ord_id: str, qty: int):
    api.order_service.amend(
        {
            "order": {
                "clientOrderId": cl_ord_id,
                "symbol": "7203.T",
                "symbolType": "reuters",
                "quantity": f"{qty}",
                "side": "BUY",
                "limitPrice": "0.0",
                "brokerAccount": "abc",
                "broker": "ms",
            }
        }
    )


def main():
    # Create an API instance and open a connection.
    with API.create_persistence(
        API_ENDPOINT, TOKEN_ENDPOINT, CLIENT_ID, GROUP, USER
    ) as api:
        n_orders = 30
        cl_ord_ids = []
        for i in range(0, n_orders):
            cl_ord_ids.append(register_order(api))
        print("Registered.")
        while True:
            time.sleep(3)
            print("Amending the order...")
            for cl_ord_id in cl_ord_ids:
                qty = random.randrange(100, 1000, 100)
                t = Thread(target=lambda: amend_order(api, cl_ord_id, qty))
                t.start()


if __name__ == "__main__":
    main()
