import sys
import uuid

sys.path.append("../../../oemsws")

from samples import _log
from oemsws.api import API
from samples.keycloak.config import (
    API_ENDPOINT,
    TOKEN_ENDPOINT,
    CLIENT_ID,
    USER,
    GROUP,
)

_log.setup()


def main():
    # Create an API instance and open a connection.
    with API.create_persistence(
        API_ENDPOINT, TOKEN_ENDPOINT, CLIENT_ID, GROUP, USER
    ) as api:
        print("Sending a borrow request...")

        response = api.borrow_service.create(
            {
                "order": {
                    "clientOrderId": str(uuid.uuid4()),
                    "symbol": "7203.T",
                    "symbolType": "reuters",
                    "requestedQuantity": 100,
                    "brokerAccount": "abc",
                    "broker": "ml",
                    "primeBroker": "gs",
                }
            }
        )

        order_id = response["orderId"]
        print(f"Borrow created: {order_id}")
        input("Hit enter to stop...\n")

    # The end of `with` statement closes the connection
    print("Connection closed.")


if __name__ == "__main__":
    main()
