import uuid

from samples.keycloak.config import (
    API_ENDPOINT,
    TOKEN_ENDPOINT,
    CLIENT_ID,
    USER,
    GROUP,
)
from oemsws.api import API
from samples import _log
import sys
from threading import Event
import pprint

sys.path.append("../../../oemsws")


_log.setup()


def get_borrows_snapshot():
    snapshot_complete_event = Event()
    borrows = {}

    # Create an API instance and open a connection.
    with API.create_persistence(
        API_ENDPOINT, TOKEN_ENDPOINT, CLIENT_ID, GROUP, USER
    ) as api:

        def on_update(update):
            for order in update.data["orders"]:
                orderId = order["orderId"]
                key = ":".join([orderId])
                borrows[key] = order

            if update.data["isComplete"]:
                snapshot_complete_event.set()

        api.borrow_service.subscribe(
            {
                "subscriptionId": str(uuid.uuid4()),
                "symbolType": "reuters",
            },
            on_update,
        )

        snapshot_complete_event.wait()
        return borrows


def main():
    borrows = get_borrows_snapshot()
    pp = pprint.PrettyPrinter(indent=4)
    pp.pprint(borrows)


if __name__ == "__main__":
    main()
