import datetime
import sys
import uuid

sys.path.append("../../../oemsws")

from samples import _log
from oemsws.api import API

from samples.keycloak.config import (
    API_ENDPOINT,
    TOKEN_ENDPOINT,
    CLIENT_ID,
    USER,
    GROUP,
)

_log.setup()


def main():
    # Create an API instance and open a connection.
    with API.create_persistence(
        API_ENDPOINT, TOKEN_ENDPOINT, CLIENT_ID, GROUP, USER
    ) as api:
        start_time = datetime.datetime.utcnow().strftime("%Y-%m-%dT%H:%M:%S.%fZ")

        def on_update(update):
            print(f"Analytics update: {update}")

        api.analytics_service.subscribe(
            {
                "subscriptionId": str(uuid.uuid4()),
                "symbolType": "reuters",
                "symbol": "7203.T",
                "startTime": start_time,
            },
            on_update,
        )
        input("Hit enter to stop...\n")

    # The end of `with` statement closes the connection
    print("Connection closed.")


if __name__ == "__main__":
    main()
