import sys
import uuid

sys.path.append("../../../oemsws")

from samples import _log
from oemsws.api import API
from samples.keycloak.config import (
    API_ENDPOINT,
    TOKEN_ENDPOINT,
    CLIENT_ID,
    USER,
    GROUP,
)

_log.setup()


def main():
    # Create an API instance and open a connection.
    with API.create_persistence(
        API_ENDPOINT,
        TOKEN_ENDPOINT,
        CLIENT_ID,
        GROUP,
        USER,
    ) as api:
        subscribed_orders = set()

        # On order update, subscribe analytic data for the order.
        def on_order_update(update):
            data = update.data
            for order in data.get("orders", []):
                order_id = order["orderId"]
                if order_id in subscribed_orders:
                    continue
                print(f"Subscribing analytic data of {order_id}...")
                api.analytics_service.subscribe(
                    {
                        "subscriptionId": order_id,
                        "orderId": order_id,
                        "useRegisterTime": True,
                        "untilClose": True,
                    },
                    print,
                )
                subscribed_orders.add(order_id)

        # Subscribe orders
        api.order_service.subscribe(
            {"subscriptionId": str(uuid.uuid4()), "symbolType": "reuters"},
            on_order_update,
        )
        input("Hit enter to stop...\n")

    # The end of `with` statement closes the connection
    print("Connection closed.")


if __name__ == "__main__":
    main()
