import sys

sys.path.append("../../../oemsws")

from samples import _log
from oemsws.api import API
from samples.keycloak.config import (
    API_ENDPOINT,
    TOKEN_ENDPOINT,
    CLIENT_ID,
    USER,
    GROUP,
)

_log.setup()


def main():
    # Create an API instance and open a connection.
    with API.create_persistence(
        API_ENDPOINT, TOKEN_ENDPOINT, CLIENT_ID, GROUP, USER
    ) as api:

        response = api.algo_definition_service.algo_strategies(
            {
                "symbol": "6298.T",
                "symbolType": "reuters",
                "broker": "gs",
            }
        )
        print(f"Algo strategies response: {response}")

        response = api.algo_definition_service.algo_details(
            {
                "symbol": "6298.T",
                "symbolType": "reuters",
                "broker": "gs",
                "algoStrategy": "VWAP",
                "algoField": "Urgency",
            }
        )
        print(f"Algo strategy details response: {response}")

        input("Hit enter to stop...\n")

    # The end of `with` statement closes the connection
    print("Connection closed.")


if __name__ == "__main__":
    main()
