import sys
import uuid

from oemsws.api import API
from oemsws.persistence import ClientCredentialsTokenPersistence
from samples import _log
from samples.client_credentials.config import (
    API_ENDPOINT,
    TOKEN_ENDPOINT,
    CLIENT_ID,
    USER,
    GROUP,
    CLIENT_SECRET,
)

sys.path.append("../../../oemsws")
_log.setup()


def main():
    # Create an API instance and open a connection.
    with API.create_persistence(
        API_ENDPOINT,
        TOKEN_ENDPOINT,
        CLIENT_ID,
        GROUP,
        USER,
        token_persistence=ClientCredentialsTokenPersistence("oemsws_access_token.txt"),
        auth_type="ping",
        client_secret=CLIENT_SECRET,
    ) as api:
        print("Registering a parent order with unspec broker...")

        parent_cl_ord_id = str(uuid.uuid4())

        response = api.order_service.register(
            {
                "order": {
                    "clientOrderId": parent_cl_ord_id,
                    "symbol": "9201.T",
                    "symbolType": "reuters",
                    "quantity": "1000",
                    "side": "BUY",
                    "limitPrice": "0.0",
                    "brokerAccount": "TestAccount1",
                    "broker": "unspec",
                }
            }
        )

        parent_order_id = response["orderId"]

        print("Booking a MANUAL child order, 200shs, under the parent...")

        cl_ord_id = str(uuid.uuid4())
        api.order_service.manual_execution(
            {
                "execution": {
                    "clientOrderId": cl_ord_id,
                    "symbol": "9201.T",
                    "symbolType": "reuters",
                    "quantity": "200",
                    "side": "BUY",
                    "price": "3043.0",
                    "brokerAccount": "TestAccount1",
                    "broker": "ms",
                    "parentId": parent_order_id,
                    "fillTime": "2024-02-06T19:00:12.345Z",
                    "bestExec": "xyz",
                    "condition": "WORKED",
                    "orderType": "STLMT",
                }
            }
        )

        print("Register and send a child order, 800shs,  under the parent...")

        cl_ord_id = str(uuid.uuid4())
        api.order_service.register_and_send(
            {
                "order": {
                    "clientOrderId": cl_ord_id,
                    "symbol": "9201.T",
                    "symbolType": "reuters",
                    "quantity": "800",
                    "side": "BUY",
                    "limitPrice": "0.0",
                    "brokerAccount": "TestAccount1",
                    "broker": "ms",
                    "parentId": parent_order_id,
                }
            }
        )

        input("Hit enter to stop...\n")

    # The end of `with` statement closes the connection
    print("Connection closed.")


if __name__ == "__main__":
    main()
