import sys
import uuid

from oemsws.api import API
from oemsws.persistence import ClientCredentialsTokenPersistence
from samples import _log
from samples.client_credentials.config import (
    API_ENDPOINT,
    TOKEN_ENDPOINT,
    CLIENT_ID,
    USER,
    GROUP,
    CLIENT_SECRET,
)

sys.path.append("../../../oemsws")
_log.setup()


def main():
    # Create an API instance and open a connection.
    symbol_list = ["7203.T", "6758.T"]

    # Create an API instance and open a connection.
    with API.create_persistence(
        API_ENDPOINT,
        TOKEN_ENDPOINT,
        CLIENT_ID,
        GROUP,
        USER,
        token_persistence=ClientCredentialsTokenPersistence("oemsws_access_token.txt"),
        auth_type="ping",
        client_secret=CLIENT_SECRET,
    ) as api:
        # create list of 2 order object
        orders = [
            {
                "order": {
                    "clientOrderId": str(uuid.uuid4()),
                    "symbol": symbol,
                    "symbolType": "reuters",
                    "quantity": 100,
                    "side": "BUY",
                    "limitPrice": 0.0,
                    "brokerAccount": "abc",
                    "broker": "ml",
                    "condition": "WORKED",
                    "orderType": "CD",
                }
            }
            for symbol in symbol_list
        ]
        order_ids = api.order_service.batch(orders, action="register")
        print(f"Registered order with orderIds: {order_ids}")

        input("Hit enter to cancel...\n")

        print("Canceling the order...")
        orders_to_cancel = [{"orderId": v["orderId"]} for v in order_ids]
        res = api.order_service.batch(orders_to_cancel, action="cancel")
        print("Cancelled order", res)

        input("Hit enter to stop...\n")

    # The end of `with` statement closes the connection
    print("Connection closed.")


if __name__ == "__main__":
    main()
