import sys
import uuid

from oemsws.api import API
from oemsws.persistence import ClientCredentialsTokenPersistence
from samples import _log
from samples.client_credentials.config import (
    API_ENDPOINT,
    TOKEN_ENDPOINT,
    CLIENT_ID,
    USER,
    GROUP,
    CLIENT_SECRET,
)

sys.path.append("../../../oemsws")
_log.setup()


def main():
    cl_id1 = str(uuid.uuid4())
    cl_id2 = str(uuid.uuid4())
    # Create an API instance and open a connection.
    with API.create_persistence(
        API_ENDPOINT,
        TOKEN_ENDPOINT,
        CLIENT_ID,
        GROUP,
        USER,
        token_persistence=ClientCredentialsTokenPersistence("oemsws_access_token.txt"),
        auth_type="ping",
        client_secret=CLIENT_SECRET,
    ) as api:
        # create list of 2 order object
        orders = [
            {
                "order": {
                    "clientOrderId": cl_id1,
                    "symbol": "7203.T",
                    "symbolType": "reuters",
                    "quantity": 100,
                    "side": "BUY",
                    "limitPrice": 0.0,
                    "brokerAccount": "abc",
                    "broker": "ml",
                    "condition": "WORKED",
                    "orderType": "CD",
                }
            },
            {
                "order": {
                    "clientOrderId": cl_id2,
                    "symbol": "6758.T",
                    "symbolType": "reuters",
                    "quantity": 100,
                    "side": "BUY",
                    "limitPrice": 0.0,
                    "brokerAccount": "abc",
                    "broker": "ml",
                    "condition": "WORKED",
                    "orderType": "CD",
                }
            },
        ]

        order_ids = api.order_service.batch(orders, action="register")

        print(f"Registered order with orderIds: {order_ids}")

        input("Hit enter to amend...\n")

        print("Amending the order...")
        amends = [
            {
                "order": {
                    "clientOrderId": cl_id1,
                    "symbol": "7203.T",
                    "symbolType": "reuters",
                    "quantity": 200,
                    "side": "BUY",
                    "limitPrice": 0.0,
                    "brokerAccount": "abc",
                    "broker": "ml",
                    "condition": "WORKED",
                    "orderType": "CD",
                }
            },
            {
                "order": {
                    "clientOrderId": cl_id2,
                    "symbol": "6758.T",
                    "symbolType": "reuters",
                    "quantity": 200,
                    "side": "BUY",
                    "limitPrice": 0.0,
                    "brokerAccount": "abc",
                    "broker": "ml",
                    "condition": "WORKED",
                    "orderType": "CD",
                }
            },
        ]
        response = api.order_service.batch(amends, action="amend")
        print(f"Amended batch: {response}")

        input("Hit enter to cancel...\n")

        print("Canceling the order...")
        orders_to_cancel = [{"orderId": v["orderId"]} for v in order_ids]
        res = api.order_service.batch(orders_to_cancel, action="cancel")
        print("Cancelled batch", res)

        input("Hit enter to stop...\n")

    # The end of `with` statement closes the connection
    print("Connection closed.")


if __name__ == "__main__":
    main()
