import pprint
import sys
import uuid
from threading import Event

from oemsws.api import API
from oemsws.persistence import ClientCredentialsTokenPersistence
from samples import _log
from samples.client_credentials.config import (
    API_ENDPOINT,
    TOKEN_ENDPOINT,
    CLIENT_ID,
    USER,
    GROUP,
    CLIENT_SECRET,
)

sys.path.append("../../../oemsws")
_log.setup()


def get_orders_snapshot():
    snapshot_complete_event = Event()
    orders = {}

    # Create an API instance and open a connection.
    with API.create_persistence(
        API_ENDPOINT,
        TOKEN_ENDPOINT,
        CLIENT_ID,
        GROUP,
        USER,
        token_persistence=ClientCredentialsTokenPersistence("oemsws_access_token.txt"),
        auth_type="ping",
        client_secret=CLIENT_SECRET,
    ) as api:

        def on_update(update):
            for order in update.data["orders"]:
                orderId = order["orderId"]
                key = ":".join([orderId])
                orders[key] = order

            if update.data["isComplete"]:
                snapshot_complete_event.set()

        api.order_service.subscribe(
            {
                "subscriptionId": str(uuid.uuid4()),
                "symbolType": "reuters",
            },
            on_update,
        )

        snapshot_complete_event.wait()
        return orders


def main():
    orders = get_orders_snapshot()
    pp = pprint.PrettyPrinter(indent=4)
    pp.pprint(orders)


if __name__ == "__main__":
    main()
