import sys
import uuid

from oemsws.api import API
from oemsws.persistence import ClientCredentialsTokenPersistence
from samples import _log
from samples.client_credentials.config import (
    API_ENDPOINT,
    TOKEN_ENDPOINT,
    CLIENT_ID,
    USER,
    GROUP,
    CLIENT_SECRET,
)

sys.path.append("../../../oemsws")
_log.setup()


def main():
    # Create an API instance and open a connection.
    with API.create_persistence(
        API_ENDPOINT,
        TOKEN_ENDPOINT,
        CLIENT_ID,
        GROUP,
        USER,
        token_persistence=ClientCredentialsTokenPersistence("oemsws_access_token.txt"),
        auth_type="ping",
        client_secret=CLIENT_SECRET,
    ) as api:

        print("Booking a MANUAL child order...")

        cl_ord_id = str(uuid.uuid4())
        response = api.order_service.manual_execution(
            {
                "execution": {
                    "clientOrderId": cl_ord_id,
                    "symbol": "7203.T",
                    "symbolType": "reuters",
                    "quantity": "200",
                    "side": "BUY",
                    "price": "3042",
                    "brokerAccount": "TestAccount1",
                    "broker": "ms",
                }
            }
        )

        order_id = response["orderId"]

        print(f"Registered manual order with orderId: {order_id}")

        input("Hit enter to stop...\n")

    # The end of `with` statement closes the connection
    print("Connection closed.")


if __name__ == "__main__":
    main()
