import sys
import uuid

from oemsws.api import API
from oemsws.persistence import ClientCredentialsTokenPersistence
from samples import _log
from samples.client_credentials.config import (
    API_ENDPOINT,
    TOKEN_ENDPOINT,
    CLIENT_ID,
    USER,
    GROUP,
    CLIENT_SECRET,
)

sys.path.append("../../../oemsws")
_log.setup()


def main():
    symbol_list = ["7203.T", "6758.T"]

    # Create an API instance and open a connection.
    with API.create_persistence(
        API_ENDPOINT,
        TOKEN_ENDPOINT,
        CLIENT_ID,
        GROUP,
        USER,
        token_persistence=ClientCredentialsTokenPersistence("oemsws_access_token.txt"),
        auth_type="ping",
        client_secret=CLIENT_SECRET,
    ) as api:
        print("Sending a borrow request...")
        orders = [
            {
                "order": {
                    "clientOrderId": str(uuid.uuid4()),
                    "symbol": symbol,
                    "symbolType": "reuters",
                    "requestedQuantity": 100,
                    "brokerAccount": "abc",
                    "broker": "ml",
                    "primeBroker": "gs",
                }
            }
            for symbol in symbol_list
        ]

        order_ids = api.borrow_service.batch(orders, action="create")

        print(f"Borrow created: {order_ids}")
        input("Hit enter to stop...\n")

    # The end of `with` statement closes the connection
    print("Connection closed.")


if __name__ == "__main__":
    main()
