import datetime
import sys
import uuid

from oemsws.api import API
from oemsws.persistence import ClientCredentialsTokenPersistence
from samples import _log
from samples.client_credentials.config import (
    API_ENDPOINT,
    TOKEN_ENDPOINT,
    CLIENT_ID,
    USER,
    GROUP,
    CLIENT_SECRET,
)

sys.path.append("../../../oemsws")
_log.setup()


def main():
    # Create an API instance and open a connection.
    with API.create_persistence(
        API_ENDPOINT,
        TOKEN_ENDPOINT,
        CLIENT_ID,
        GROUP,
        USER,
        token_persistence=ClientCredentialsTokenPersistence("oemsws_access_token.txt"),
        auth_type="ping",
        client_secret=CLIENT_SECRET,
    ) as api:
        start_time = datetime.datetime.utcnow().strftime("%Y-%m-%dT%H:%M:%S.%fZ")

        def on_update(update):
            print(f"Analytics update: {update}")

        api.analytics_service.subscribe(
            {
                "subscriptionId": str(uuid.uuid4()),
                "symbol": "7203.T",
                "symbolType": "reuters",
                "startTime": start_time,
            },
            on_update,
        )
        input("Hit enter to stop...\n")

    # The end of `with` statement closes the connection
    print("Connection closed.")


if __name__ == "__main__":
    main()
