import datetime
import logging
import os
import sys

_format = "%(asctime)s %(levelname)s [%(thread)d %(name)s] %(message)s"


def get_script_dir():
    """Get the directory path of the entry point.
    :return: a string of the directory path
    """
    return os.path.dirname(os.path.realpath(sys.argv[0]))


def setup():
    log_file_path = _get_log_file_path()
    logger = logging.getLogger()
    logger.setLevel(logging.DEBUG)
    formatter = logging.Formatter(_format)
    stream_handler = _setup_stream_handler(formatter)
    logger.addHandler(stream_handler)
    file_handler = _setup_file_handler(log_file_path, formatter)
    logger.addHandler(file_handler)


def _setup_file_handler(file_path, formatter):
    file_handler = logging.FileHandler(file_path)
    file_handler.setFormatter(formatter)
    file_handler.setLevel(logging.DEBUG)
    return file_handler


def _setup_stream_handler(formatter):
    handler = logging.StreamHandler(sys.stdout)
    handler.setFormatter(formatter)
    handler.setLevel(logging.INFO)
    return handler


def _get_log_file_path():
    date = datetime.datetime.now().strftime("%Y-%m-%d")
    log_path = os.path.join(get_script_dir(), "logs", f"oemsws_examples_{date}.log")
    dir_name = os.path.dirname(log_path)
    os.makedirs(dir_name, exist_ok=True)
    return log_path
