from threading import Event

from oemsws.exceptions import Timeout


class SettableEvent:
    """Event object with data.

    This works like threading.Event objects, but it can set data.
    When set(data) is called, a thread calling get_result() receives the data
    as return value.
    It behaves in the same way as TaskCompletionSource in .NET and
    SettableFuture in Java.

    """

    def __init__(self):
        self._data = None
        self.event = Event()

    def get_result(self, timeout=None):
        """Wait and get a result.

        This method blocks the calling thread until data is set.

        :param timeout: timeout period in seconds.
        :raise: Timeout if waiting time exceeds the timeout period.
        """
        success = self.event.wait(timeout)
        if not success:
            raise Timeout()
        return self._data

    def set(self, data):
        """Set data with triggering the event.

        :param data: an object to be returned by get_result().
        """
        self._data = data
        self.event.set()
