from typing import Dict, Callable

from oemsws.models import ServerMessage
from oemsws.schema import AnalyticsSubscribe
from oemsws.session import Subscription
from oemsws.constants import ANALYTICS, TIMEOUT
from oemsws.session import Session
from oemsws.validator import validate


class AnalyticsService:
    def __init__(self, session: Session):
        self._session = session

    @validate(schema=AnalyticsSubscribe)
    def subscribe(
        self,
        params: Dict,
        on_update: Callable[[ServerMessage], None],
        *,
        timeout=TIMEOUT
    ) -> Subscription:
        """Subscribe analytical data.

        :param params: a dict object of subscribe action parameters
            described in Tora API documentation.
        :param on_update: a handler called on update. The first argument of the
            handler is a Response object. The handler is
            executed on a new thread. Unhandled exceptions in the handler are
            ignored.
        :param timeout: timeout period in seconds.
        :return: Subscription object with an unsubscribe method that
            unsubscribes the created subscription.
        :raise Timeout: if a response is not received within the timeout.
        :raise ResponseError: if the received response has error status.
        :raise WebSocketConnectionError: if websocket fails to send the message.
        """
        return self._session.subscribe(ANALYTICS, params, on_update, timeout)
