# Global default timeout in seconds
import collections

TIMEOUT = 30.0

LIB_NAME = "oemsws"
MESSAGE_ID = "messageId"
SERVICE = "service"
ACTION = "action"
EVENT = "event"
AUTH = "auth"
ORDERS = "orders"
PAIRS = "pairs"
EXECUTIONS = "executions"
POSITIONS = "positions"
ANALYTICS = "analytics"
TRADING_CAPABILITIES = "tradingcapabilities"
PRODUCT = "product"
COMPLIANCES = "compliances"
BORROW = "borrow"
SUBSCRIBE = "subscribe"
UNSUBSCRIBE = "unsubscribe"
UPDATE = "update"
SHUTDOWN = "shutdown"
GENERIC_SEARCH = "generic-search"
MARKET_PROPERTIES = "get-market-properties"
PRODUCT_DETAILS = "get-product-details"
MESSAGE_REFERENCE_ID = "messageReferenceId"
DATA = "data"
PARAMS = "params"
SUBSCRIPTION_ID = "subscriptionId"
SYMBOL_TYPE = "symbolType"
GROUP_BY = "groupBy"
STATUS = "status"
CODE = "code"
MESSAGE = "message"
OPEN_ID_CONNECT = "openIdConnect"
IS_COMPLETE = "isComplete"
USER = "user"
GROUP = "group"
ID_TOKEN = "idToken"
ACCESS_TOKEN = "accessToken"
AUTH_METHOD = "authMethod"
VWAP = "vwap"
ACCUMULATED = "accumulated"
SEND = "send"
REGISTER = "register"
REGISTER_AND_SEND = "registerAndSend"
AMEND = "amend"
CANCEL = "cancel"
APPROVAL_DECISION = "approval decision"
APPROVAL_RESPONSE = "approval response"
ORDER_ID = "orderId"
EXECUTION_ID = "executionId"
ORDER = "order"
CLIENT_ORDER_ID = "clientOrderId"
QUANTITY = "quantity"
BROKER = "broker"
BROKER_ACCOUNT = "brokerAccount"
LIMIT_PRICE = "limitPrice"
SYMBOL = "symbol"
SIDE = "side"
CONDITION = "condition"
INTERNAL_ACCOUNT = "internalAccount"
TRADE_BOOK = "tradeBook"
OWNER = "owner"
TAG = "tag"
ALLOCATION_METHOD = "allocationMethod"
REFERENCE_PRICE = "referencePrice"
SYNTH_TYPE = "synthType"
ORDER_TYPE = "orderType"
TIME_IN_FORCE = "timeInForce"
OPEN_CLOSE = "openClose"
PARENT_ID = "parentId"
EXCHANGE = "exchange"
BORROW_CREATE = "create"
ALGO = "algo"
ALGO_DETAILS = "get-algo-details"
ALGO_STRATEGIES = "get-algo-strategies"
QUOTES = "quotes"
REQUEST = "request"
MANUAL_EXECUTION = "manualExecution"
PAIRUP = "pairUp"

PARAMETERS_TO_TAGS_MAPPING = collections.OrderedDict(
    {
        "Strategy": "8500",
        "Version": "7621",
        "target_spread": "6004",
        "target_ratio": "6003",
        "secondary_avg_price": "8178",
        "primary_avg_price": "8078",
        "pair_session_info_tag": "8076",
        "pair_executed_conversion_rate": "8075",
        "pair_error_reason": "8043",
        "active_cover_count": "8042",
        "pairs_is_hung": "8041",
        "leg2_instrument": "6101",
        "leg1_instrument": "6001",
        "leg2_threshold": "6109",
        "leg1_threshold": "6009",
        "leg_strategy": "6000",
        "leg2_slippage": "6108",
        "leg1_slippage": "6008",
        "slippage_percent_type": "6014",
        "leg2_concurrency": "6111",
        "leg1_concurrency": "6011",
        "leg2_slice_manual": "6107",
        "leg1_slice_manual": "6007",
        "leg2_primary": "6115",
        "leg1_primary": "6015",
        "leg2_enable_passive_pov": "6197",
        "leg2_enable_pov": "6199",
        "leg1_enable_passive_pov": "6097",
        "leg1_enable_pov": "6099",
        "leg2_pov_type": "6196",
        "leg1_pov_type": "6096",
        "pairs_ord_status": "6041",
        "incremental_float": "8056",
        "conversion": "6005",
        "leg2_execution_style": "6110",
        "leg1_execution_style": "6010",
        "leg2_executing_broker": "6117",
        "leg1_executing_broker": "6017",
        "continuous": "8057",
        "check_available_liquidity": "8053",
        "pairs_alert_action_type": "6040",
        # above are ordered as per ATDL
        "aggressive_vol_pct": "8065",
        "baseccy": "8062",
        "catch_up_strategy": "8064",
        "custom_executing_broker": "6018",
        "defined_conversion": "6006",
        "enable_i_would_ratio": "8060",
        "enable_i_would_spread": "8061",
        "end_time": "8100",
        "end_time_enable": "8102",
        "i_would_ratio": "8058",
        "i_would_spread": "8059",
        "increment_pct": "8055",
        "leg1_pov": "6098",
        "leg2_pov": "6198",
        "name": "6002",
        "pairs_alert_action_type_second": "8069",
        "start_time": "8099",
        "start_time_enable": "8101",
        "time_tolerance": "8068",
        "time_tolerance_enable": "8070",
        "trade_the_residual": "8054",
        "twap_timed": "8063",
    }
)

CONVERSION_MAP = {
    "6005": {
        "Defined FX": "DEFINED",
        "Live FX": "CURRENCY",
        "Auto Hedge FX": "AUTO_HEDGE_BASE",
        "None": "NONE",
    },
    "6096": {"All": "ALL", "None": "NONE", "Marketable": "MARKETABLE"},
    "6196": {"All": "ALL", "None": "NONE", "Marketable": "MARKETABLE"},
    "8041": {
        "true": "Y",
        "false": "N",
    },
    "6014": {
        "true": "Y",
        "false": "N",
    },
    "6115": {
        "true": "Y",
        "false": "N",
    },
    "6015": {
        "true": "Y",
        "false": "N",
    },
    "6197": {
        "true": "Y",
        "false": "N",
    },
    "6199": {
        "true": "Y",
        "false": "N",
    },
    "6097": {
        "true": "Y",
        "false": "N",
    },
    "6099": {
        "true": "Y",
        "false": "N",
    },
    "8061": {
        "true": "Y",
        "false": "N",
    },
    "8060": {
        "true": "Y",
        "false": "N",
    },
    "8056": {
        "true": "Y",
        "false": "N",
    },
    "8057": {
        "true": "Y",
        "false": "N",
    },
    "8053": {
        "true": "Y",
        "false": "N",
    },
    "8070": {
        "true": "Y",
        "false": "N",
    },
    "8102": {
        "true": "Y",
        "false": "N",
    },
    "8101": {
        "true": "Y",
        "false": "N",
    },
    "6010": {
        "PASSIVE": "PASSIVE",
        "LAST_PRICE": "LAST",
        "AGGRESSIVE": "AGGRESSIVE",
        "DEFAULT": "DEFAULT",
    },
    "6110": {
        "PASSIVE": "PASSIVE",
        "LAST_PRICE": "LAST",
        "AGGRESSIVE": "AGGRESSIVE",
        "DEFAULT": "DEFAULT",
    },
    "8064": {
        "Passive": "PASSIVE",
        "Aggressive": "AGGRESSIVE",
    },
}
