/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core.buffer;

import java.io.IOException;
import java.io.OutputStream;
import org.msgpack.core.Preconditions;
import org.msgpack.core.buffer.MessageBuffer;
import org.msgpack.core.buffer.MessageBufferOutput;

public class OutputStreamBufferOutput
implements MessageBufferOutput {
    private OutputStream out;
    private MessageBuffer buffer;

    public OutputStreamBufferOutput(OutputStream outputStream2) {
        this(outputStream2, 8192);
    }

    public OutputStreamBufferOutput(OutputStream outputStream2, int n2) {
        this.out = Preconditions.checkNotNull(outputStream2, "output is null");
        this.buffer = MessageBuffer.allocate(n2);
    }

    public OutputStream reset(OutputStream outputStream2) throws IOException {
        OutputStream outputStream3 = this.out;
        this.out = outputStream2;
        return outputStream3;
    }

    @Override
    public MessageBuffer next(int n2) throws IOException {
        if (this.buffer.size() < n2) {
            this.buffer = MessageBuffer.allocate(n2);
        }
        return this.buffer;
    }

    @Override
    public void writeBuffer(int n2) throws IOException {
        this.write(this.buffer.array(), this.buffer.arrayOffset(), n2);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.out.write(byArray, n2, n3);
    }

    @Override
    public void add(byte[] byArray, int n2, int n3) throws IOException {
        this.write(byArray, n2, n3);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }
}

