/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core.buffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.msgpack.core.Preconditions;
import org.msgpack.core.buffer.MessageBuffer;
import org.msgpack.core.buffer.MessageBufferInput;

public class ChannelBufferInput
implements MessageBufferInput {
    private ReadableByteChannel channel;
    private final MessageBuffer buffer;

    public ChannelBufferInput(ReadableByteChannel readableByteChannel) {
        this(readableByteChannel, 8192);
    }

    public ChannelBufferInput(ReadableByteChannel readableByteChannel, int n2) {
        this.channel = Preconditions.checkNotNull(readableByteChannel, "input channel is null");
        Preconditions.checkArgument(n2 > 0, "buffer size must be > 0: " + n2);
        this.buffer = MessageBuffer.allocate(n2);
    }

    public ReadableByteChannel reset(ReadableByteChannel readableByteChannel) throws IOException {
        ReadableByteChannel readableByteChannel2 = this.channel;
        this.channel = readableByteChannel;
        return readableByteChannel2;
    }

    @Override
    public MessageBuffer next() throws IOException {
        int n2;
        ByteBuffer byteBuffer = this.buffer.sliceAsByteBuffer();
        while (byteBuffer.remaining() > 0 && (n2 = this.channel.read(byteBuffer)) != -1) {
        }
        byteBuffer.flip();
        return byteBuffer.remaining() == 0 ? null : this.buffer.slice(0, byteBuffer.limit());
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

