/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.AnnotatedElement;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.CompressingDataOutputStream;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.TypeVariableReference;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.BindingAnnotationTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.FormalBinding;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.PatternNodeVisitor;

public class ExactAnnotationTypePattern
extends AnnotationTypePattern {
    protected UnresolvedType annotationType;
    protected String formalName;
    protected boolean resolved = false;
    protected boolean bindingPattern = false;
    private Map<String, String> annotationValues;
    private static byte VERSION = 1;

    public ExactAnnotationTypePattern(UnresolvedType annotationType, Map<String, String> annotationValues) {
        this.annotationType = annotationType;
        this.annotationValues = annotationValues;
        this.resolved = annotationType instanceof ResolvedType;
    }

    private ExactAnnotationTypePattern(UnresolvedType annotationType) {
        this.annotationType = annotationType;
        this.resolved = annotationType instanceof ResolvedType;
    }

    protected ExactAnnotationTypePattern(String formalName) {
        this.formalName = formalName;
        this.resolved = false;
        this.bindingPattern = true;
    }

    public ResolvedType getResolvedAnnotationType() {
        if (!this.resolved) {
            throw new IllegalStateException("I need to be resolved first!");
        }
        return (ResolvedType)this.annotationType;
    }

    public UnresolvedType getAnnotationType() {
        return this.annotationType;
    }

    public Map<String, String> getAnnotationValues() {
        return this.annotationValues;
    }

    @Override
    public FuzzyBoolean fastMatches(AnnotatedElement annotated) {
        if (annotated.hasAnnotation(this.annotationType) && this.annotationValues == null) {
            return FuzzyBoolean.YES;
        }
        return FuzzyBoolean.MAYBE;
    }

    @Override
    public FuzzyBoolean matches(AnnotatedElement annotated) {
        return this.matches(annotated, null);
    }

    @Override
    public FuzzyBoolean matches(AnnotatedElement annotated, ResolvedType[] parameterAnnotations) {
        block17: {
            block16: {
                if (this.isForParameterAnnotationMatch()) break block16;
                boolean checkSupers = false;
                if (this.getResolvedAnnotationType().isInheritedAnnotation() && annotated instanceof ResolvedType) {
                    checkSupers = true;
                }
                if (annotated.hasAnnotation(this.annotationType)) {
                    ReferenceType rt;
                    if (this.annotationType instanceof ReferenceType && (rt = (ReferenceType)this.annotationType).getRetentionPolicy() != null && rt.getRetentionPolicy().equals("SOURCE")) {
                        rt.getWorld().getMessageHandler().handleMessage(MessageUtil.warn(WeaverMessages.format("noMatchBecauseSourceRetention", this.annotationType, annotated), this.getSourceLocation()));
                        return FuzzyBoolean.NO;
                    }
                    if (this.annotationValues != null) {
                        AnnotationAJ theAnnotation = annotated.getAnnotationOfType(this.annotationType);
                        Set<String> keys2 = this.annotationValues.keySet();
                        for (String k2 : keys2) {
                            boolean notEqual = false;
                            String v2 = this.annotationValues.get(k2);
                            if (k2.endsWith("!")) {
                                notEqual = true;
                                k2 = k2.substring(0, k2.length() - 1);
                            }
                            if (theAnnotation.hasNamedValue(k2)) {
                                if (!(notEqual ? theAnnotation.hasNameValuePair(k2, v2) : !theAnnotation.hasNameValuePair(k2, v2))) continue;
                                return FuzzyBoolean.NO;
                            }
                            ResolvedMember[] ms = ((ResolvedType)this.annotationType).getDeclaredMethods();
                            boolean foundMatch = false;
                            for (int i2 = 0; i2 < ms.length && !foundMatch; ++i2) {
                                String s2;
                                if (!ms[i2].isAbstract() || ms[i2].getParameterTypes().length != 0 || !ms[i2].getName().equals(k2) || (s2 = ms[i2].getAnnotationDefaultValue()) == null || !s2.equals(v2)) continue;
                                foundMatch = true;
                            }
                            if (!(notEqual ? foundMatch : !foundMatch)) continue;
                            return FuzzyBoolean.NO;
                        }
                    }
                    return FuzzyBoolean.YES;
                }
                if (!checkSupers) break block17;
                for (ResolvedType toMatchAgainst = ((ResolvedType)annotated).getSuperclass(); toMatchAgainst != null; toMatchAgainst = toMatchAgainst.getSuperclass()) {
                    if (!toMatchAgainst.hasAnnotation(this.annotationType)) continue;
                    if (this.annotationValues != null) {
                        AnnotationAJ theAnnotation = toMatchAgainst.getAnnotationOfType(this.annotationType);
                        Set<String> keys3 = this.annotationValues.keySet();
                        for (String k3 : keys3) {
                            String v3 = this.annotationValues.get(k3);
                            if (theAnnotation.hasNamedValue(k3)) {
                                if (theAnnotation.hasNameValuePair(k3, v3)) continue;
                                return FuzzyBoolean.NO;
                            }
                            ResolvedMember[] ms = ((ResolvedType)this.annotationType).getDeclaredMethods();
                            boolean foundMatch = false;
                            for (int i3 = 0; i3 < ms.length && !foundMatch; ++i3) {
                                String s3;
                                if (!ms[i3].isAbstract() || ms[i3].getParameterTypes().length != 0 || !ms[i3].getName().equals(k3) || (s3 = ms[i3].getAnnotationDefaultValue()) == null || !s3.equals(v3)) continue;
                                foundMatch = true;
                            }
                            if (foundMatch) continue;
                            return FuzzyBoolean.NO;
                        }
                    }
                    return FuzzyBoolean.YES;
                }
                break block17;
            }
            if (parameterAnnotations == null) {
                return FuzzyBoolean.NO;
            }
            for (ResolvedType parameterAnnotation : parameterAnnotations) {
                if (!this.annotationType.equals(parameterAnnotation)) continue;
                if (this.annotationValues != null) {
                    parameterAnnotation.getWorld().getMessageHandler().handleMessage(MessageUtil.error("Compiler limitation: annotation value matching for parameter annotations not yet supported"));
                    return FuzzyBoolean.NO;
                }
                return FuzzyBoolean.YES;
            }
        }
        return FuzzyBoolean.NO;
    }

    public FuzzyBoolean matchesRuntimeType(AnnotatedElement annotated) {
        if (this.getResolvedAnnotationType().isInheritedAnnotation() && this.matches(annotated).alwaysTrue()) {
            return FuzzyBoolean.YES;
        }
        return FuzzyBoolean.MAYBE;
    }

    @Override
    public void resolve(World world) {
        if (!this.resolved) {
            this.annotationType = this.annotationType.resolve(world);
            this.resolved = true;
        }
    }

    @Override
    public AnnotationTypePattern resolveBindings(IScope scope, Bindings bindings, boolean allowBinding) {
        FormalBinding formalBinding;
        if (this.resolved) {
            return this;
        }
        this.resolved = true;
        String simpleName = this.maybeGetSimpleName();
        if (simpleName != null && (formalBinding = scope.lookupFormal(simpleName)) != null) {
            if (bindings == null) {
                scope.message(IMessage.ERROR, this, "negation doesn't allow binding");
                return this;
            }
            if (!allowBinding) {
                scope.message(IMessage.ERROR, this, "name binding only allowed in @pcds, args, this, and target");
                return this;
            }
            this.formalName = simpleName;
            this.bindingPattern = true;
            this.verifyIsAnnotationType(formalBinding.getType().resolve(scope.getWorld()), scope);
            BindingAnnotationTypePattern binding = new BindingAnnotationTypePattern(formalBinding);
            binding.copyLocationFrom(this);
            bindings.register(binding, scope);
            binding.resolveBinding(scope.getWorld());
            if (this.isForParameterAnnotationMatch()) {
                binding.setForParameterAnnotationMatch();
            }
            return binding;
        }
        String cleanname = this.annotationType.getName();
        this.annotationType = scope.getWorld().resolve(this.annotationType, true);
        if (ResolvedType.isMissing(this.annotationType)) {
            int lastDot;
            UnresolvedType type = null;
            while (ResolvedType.isMissing(type = scope.lookupType(cleanname, this)) && (lastDot = cleanname.lastIndexOf(46)) != -1) {
                cleanname = cleanname.substring(0, lastDot) + "$" + cleanname.substring(lastDot + 1);
            }
            this.annotationType = scope.getWorld().resolve(type, true);
        }
        this.verifyIsAnnotationType((ResolvedType)this.annotationType, scope);
        return this;
    }

    @Override
    public AnnotationTypePattern parameterizeWith(Map<String, UnresolvedType> typeVariableMap, World w2) {
        UnresolvedType newAnnotationType = this.annotationType;
        if (this.annotationType.isTypeVariableReference()) {
            TypeVariableReference t2 = (TypeVariableReference)((Object)this.annotationType);
            String key = t2.getTypeVariable().getName();
            if (typeVariableMap.containsKey(key)) {
                newAnnotationType = typeVariableMap.get(key);
            }
        } else if (this.annotationType.isParameterizedType()) {
            newAnnotationType = this.annotationType.parameterize(typeVariableMap);
        }
        ExactAnnotationTypePattern ret = new ExactAnnotationTypePattern(newAnnotationType, this.annotationValues);
        ret.formalName = this.formalName;
        ret.bindingPattern = this.bindingPattern;
        ret.copyLocationFrom(this);
        if (this.isForParameterAnnotationMatch()) {
            ret.setForParameterAnnotationMatch();
        }
        return ret;
    }

    protected String maybeGetSimpleName() {
        if (this.formalName != null) {
            return this.formalName;
        }
        String ret = this.annotationType.getName();
        return ret.indexOf(46) == -1 ? ret : null;
    }

    protected void verifyIsAnnotationType(ResolvedType type, IScope scope) {
        if (!type.isAnnotation()) {
            IMessage m4 = MessageUtil.error(WeaverMessages.format("referenceToNonAnnotationType", type.getName()), this.getSourceLocation());
            scope.getWorld().getMessageHandler().handleMessage(m4);
            this.resolved = false;
        }
    }

    @Override
    public void write(CompressingDataOutputStream s2) throws IOException {
        s2.writeByte(1);
        s2.writeByte(VERSION);
        s2.writeBoolean(this.bindingPattern);
        if (this.bindingPattern) {
            s2.writeUTF(this.formalName);
        } else {
            this.annotationType.write(s2);
        }
        this.writeLocation(s2);
        s2.writeBoolean(this.isForParameterAnnotationMatch());
        if (this.annotationValues == null) {
            s2.writeInt(0);
        } else {
            s2.writeInt(this.annotationValues.size());
            Set<String> key = this.annotationValues.keySet();
            for (String k2 : key) {
                s2.writeUTF(k2);
                s2.writeUTF(this.annotationValues.get(k2));
            }
        }
    }

    public static AnnotationTypePattern read(VersionedDataInputStream s2, ISourceContext context) throws IOException {
        int annotationValueCount;
        byte version = s2.readByte();
        if (version > VERSION) {
            throw new BCException("ExactAnnotationTypePattern was written by a newer version of AspectJ");
        }
        boolean isBindingPattern = s2.readBoolean();
        ExactAnnotationTypePattern ret = isBindingPattern ? new ExactAnnotationTypePattern(s2.readUTF()) : new ExactAnnotationTypePattern(UnresolvedType.read(s2));
        ret.readLocation(context, s2);
        if (s2.getMajorVersion() >= 4 && s2.readBoolean()) {
            ret.setForParameterAnnotationMatch();
        }
        if (s2.getMajorVersion() >= 5 && (annotationValueCount = s2.readInt()) > 0) {
            HashMap<String, String> aValues = new HashMap<String, String>();
            for (int i2 = 0; i2 < annotationValueCount; ++i2) {
                String key = s2.readUTF();
                String val2 = s2.readUTF();
                aValues.put(key, val2);
            }
            ret.annotationValues = aValues;
        }
        return ret;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExactAnnotationTypePattern)) {
            return false;
        }
        ExactAnnotationTypePattern other = (ExactAnnotationTypePattern)obj;
        return other.annotationType.equals(this.annotationType) && this.isForParameterAnnotationMatch() == other.isForParameterAnnotationMatch() && (this.annotationValues == null ? other.annotationValues == null : this.annotationValues.equals(other.annotationValues));
    }

    public int hashCode() {
        return (this.annotationType.hashCode() * 37 + (this.isForParameterAnnotationMatch() ? 0 : 1)) * 37 + (this.annotationValues == null ? 0 : this.annotationValues.hashCode());
    }

    public String toString() {
        if (!this.resolved && this.formalName != null) {
            return this.formalName;
        }
        String ret = "@" + this.annotationType.toString();
        if (this.formalName != null) {
            ret = ret + " " + this.formalName;
        }
        return ret;
    }

    @Override
    public Object accept(PatternNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }
}

