/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.IOException;
import java.util.Map;
import org.aspectj.weaver.CompressingDataOutputStream;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.PatternNodeVisitor;
import org.aspectj.weaver.patterns.Pointcut;

public class DeclareErrorOrWarning
extends Declare {
    private boolean isError;
    private Pointcut pointcut;
    private String message;

    public DeclareErrorOrWarning(boolean isError, Pointcut pointcut, String message) {
        this.isError = isError;
        this.pointcut = pointcut;
        this.message = message;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("declare ");
        if (this.isError) {
            buf.append("error: ");
        } else {
            buf.append("warning: ");
        }
        buf.append(this.pointcut);
        buf.append(": ");
        buf.append("\"");
        buf.append(this.message);
        buf.append("\";");
        return buf.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof DeclareErrorOrWarning)) {
            return false;
        }
        DeclareErrorOrWarning o2 = (DeclareErrorOrWarning)other;
        return o2.isError == this.isError && o2.pointcut.equals(this.pointcut) && o2.message.equals(this.message);
    }

    public int hashCode() {
        int result = this.isError ? 19 : 23;
        result = 37 * result + this.pointcut.hashCode();
        result = 37 * result + this.message.hashCode();
        return result;
    }

    @Override
    public Object accept(PatternNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void write(CompressingDataOutputStream s2) throws IOException {
        s2.writeByte(1);
        s2.writeBoolean(this.isError);
        this.pointcut.write(s2);
        s2.writeUTF(this.message);
        this.writeLocation(s2);
    }

    public static Declare read(VersionedDataInputStream s2, ISourceContext context) throws IOException {
        DeclareErrorOrWarning ret = new DeclareErrorOrWarning(s2.readBoolean(), Pointcut.read(s2, context), s2.readUTF());
        ret.readLocation(context, s2);
        return ret;
    }

    public boolean isError() {
        return this.isError;
    }

    public String getMessage() {
        return this.message;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    @Override
    public void resolve(IScope scope) {
        this.pointcut = this.pointcut.resolve(scope);
    }

    @Override
    public Declare parameterizeWith(Map<String, UnresolvedType> typeVariableBindingMap, World w2) {
        DeclareErrorOrWarning ret = new DeclareErrorOrWarning(this.isError, this.pointcut.parameterizeWith(typeVariableBindingMap, w2), this.message);
        ret.copyLocationFrom(this);
        return ret;
    }

    @Override
    public boolean isAdviceLike() {
        return true;
    }

    @Override
    public String getNameSuffix() {
        return "eow";
    }

    public String getName() {
        StringBuffer buf = new StringBuffer();
        buf.append("declare ");
        if (this.isError) {
            buf.append("error");
        } else {
            buf.append("warning");
        }
        return buf.toString();
    }
}

