/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.loadtime.definition;

import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class LightXMLParser {
    private static final char NULL_CHAR = '\u0000';
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private ArrayList children = new ArrayList();
    private String name = null;
    private char pushedBackChar;
    private Reader reader;
    private static Map<String, char[]> entities = new HashMap<String, char[]>();

    public ArrayList getChildrens() {
        return this.children;
    }

    public String getName() {
        return this.name;
    }

    public void parseFromReader(Reader reader) throws Exception {
        char c2;
        this.pushedBackChar = '\u0000';
        this.attributes = new HashMap<String, Object>();
        this.name = null;
        this.children = new ArrayList();
        this.reader = reader;
        while (true) {
            if ((c2 = this.skipBlanks()) != '<') {
                throw new Exception("LightParser Exception: Expected < but got: " + c2);
            }
            c2 = this.getNextChar();
            if (c2 != '!' && c2 != '?') break;
            this.skipCommentOrXmlTag(0);
        }
        this.pushBackChar(c2);
        this.parseNode(this);
    }

    private char skipBlanks() throws Exception {
        char c2;
        block3: while (true) {
            c2 = this.getNextChar();
            switch (c2) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
            }
            break;
        }
        return c2;
    }

    private char getWhitespaces(StringBuffer result) throws Exception {
        char c2;
        block4: while (true) {
            c2 = this.getNextChar();
            switch (c2) {
                case '\t': 
                case '\n': 
                case ' ': {
                    result.append(c2);
                }
                case '\r': {
                    continue block4;
                }
            }
            break;
        }
        return c2;
    }

    private void getNodeName(StringBuffer result) throws Exception {
        while (true) {
            char c2;
            if (!((c2 = this.getNextChar()) >= 'a' && c2 <= 'z' || c2 <= 'Z' && c2 >= 'A' || c2 <= '9' && c2 >= '0' || c2 == '_' || c2 == '-' || c2 == '.' || c2 == ':')) {
                this.pushBackChar(c2);
                return;
            }
            result.append(c2);
        }
    }

    private void getString(StringBuffer string) throws Exception {
        char delimiter = this.getNextChar();
        if (delimiter != '\'' && delimiter != '\"') {
            throw new Exception("Parsing error. Expected ' or \"  but got: " + delimiter);
        }
        char c2;
        while ((c2 = this.getNextChar()) != delimiter) {
            if (c2 == '&') {
                this.mapEntity(string);
                continue;
            }
            string.append(c2);
        }
        return;
    }

    private void getPCData(StringBuffer data) throws Exception {
        while (true) {
            char c2;
            if ((c2 = this.getNextChar()) == '<') {
                c2 = this.getNextChar();
                if (c2 == '!') {
                    this.checkCDATA(data);
                    continue;
                }
                this.pushBackChar(c2);
                return;
            }
            data.append(c2);
        }
    }

    private boolean checkCDATA(StringBuffer buf) throws Exception {
        char c2 = this.getNextChar();
        if (c2 != '[') {
            this.pushBackChar(c2);
            this.skipCommentOrXmlTag(0);
            return false;
        }
        if (!this.checkLiteral("CDATA[")) {
            this.skipCommentOrXmlTag(1);
            return false;
        }
        int delimiterCharsSkipped = 0;
        block4: while (delimiterCharsSkipped < 3) {
            int i2;
            c2 = this.getNextChar();
            switch (c2) {
                case ']': {
                    if (delimiterCharsSkipped < 2) {
                        ++delimiterCharsSkipped;
                        continue block4;
                    }
                    buf.append(']');
                    buf.append(']');
                    delimiterCharsSkipped = 0;
                    continue block4;
                }
                case '>': {
                    if (delimiterCharsSkipped < 2) {
                        for (i2 = 0; i2 < delimiterCharsSkipped; ++i2) {
                            buf.append(']');
                        }
                        delimiterCharsSkipped = 0;
                        buf.append('>');
                        continue block4;
                    }
                    delimiterCharsSkipped = 3;
                    continue block4;
                }
            }
            for (i2 = 0; i2 < delimiterCharsSkipped; ++i2) {
                buf.append(']');
            }
            buf.append(c2);
            delimiterCharsSkipped = 0;
        }
        return true;
    }

    private void skipCommentOrXmlTag(int bracketLevel) throws Exception {
        char c2;
        char delim = '\u0000';
        int level = 1;
        if (bracketLevel == 0) {
            c2 = this.getNextChar();
            if (c2 == '-') {
                c2 = this.getNextChar();
                if (c2 == ']') {
                    --bracketLevel;
                } else if (c2 == '[') {
                    ++bracketLevel;
                } else if (c2 == '-') {
                    this.skipComment();
                    return;
                }
            } else if (c2 == '[') {
                ++bracketLevel;
            }
        }
        while (level > 0) {
            c2 = this.getNextChar();
            if (delim == '\u0000') {
                if (c2 == '\"' || c2 == '\'') {
                    delim = c2;
                } else if (bracketLevel <= 0) {
                    if (c2 == '<') {
                        ++level;
                    } else if (c2 == '>') {
                        --level;
                    }
                }
                if (c2 == '[') {
                    ++bracketLevel;
                    continue;
                }
                if (c2 != ']') continue;
                --bracketLevel;
                continue;
            }
            if (c2 != delim) continue;
            delim = '\u0000';
        }
    }

    private void parseNode(LightXMLParser elt) throws Exception {
        char c2;
        String name;
        StringBuffer buf;
        block20: {
            buf = new StringBuffer();
            this.getNodeName(buf);
            name = buf.toString();
            elt.setName(name);
            c2 = this.skipBlanks();
            while (c2 != '>' && c2 != '/') {
                this.emptyBuf(buf);
                this.pushBackChar(c2);
                this.getNodeName(buf);
                String key = buf.toString();
                c2 = this.skipBlanks();
                if (c2 != '=') {
                    throw new Exception("Parsing error. Expected = but got: " + c2);
                }
                this.pushBackChar(this.skipBlanks());
                this.emptyBuf(buf);
                this.getString(buf);
                elt.setAttribute(key, buf);
                c2 = this.skipBlanks();
            }
            if (c2 == '/') {
                c2 = this.getNextChar();
                if (c2 != '>') {
                    throw new Exception("Parsing error. Expected > but got: " + c2);
                }
                return;
            }
            this.emptyBuf(buf);
            c2 = this.getWhitespaces(buf);
            if (c2 != '<') {
                this.pushBackChar(c2);
                this.getPCData(buf);
            } else {
                while ((c2 = this.getNextChar()) == '!') {
                    if (this.checkCDATA(buf)) {
                        this.getPCData(buf);
                    } else {
                        c2 = this.getWhitespaces(buf);
                        if (c2 == '<') continue;
                        this.pushBackChar(c2);
                        this.getPCData(buf);
                    }
                    break block20;
                }
                if (c2 != '/') {
                    this.emptyBuf(buf);
                }
                if (c2 == '/') {
                    this.pushBackChar(c2);
                }
            }
        }
        if (buf.length() == 0) {
            while (c2 != '/') {
                if (c2 == '!') {
                    for (int i2 = 0; i2 < 2; ++i2) {
                        c2 = this.getNextChar();
                        if (c2 == '-') continue;
                        throw new Exception("Parsing error. Expected element or comment");
                    }
                    this.skipComment();
                } else {
                    this.pushBackChar(c2);
                    LightXMLParser child = this.createAnotherElement();
                    this.parseNode(child);
                    elt.addChild(child);
                }
                c2 = this.skipBlanks();
                if (c2 != '<') {
                    throw new Exception("Parsing error. Expected <, but got: " + c2);
                }
                c2 = this.getNextChar();
            }
            this.pushBackChar(c2);
        }
        if ((c2 = this.getNextChar()) != '/') {
            throw new Exception("Parsing error. Expected /, but got: " + c2);
        }
        this.pushBackChar(this.skipBlanks());
        if (!this.checkLiteral(name)) {
            throw new Exception("Parsing error. Expected " + name);
        }
        if (this.skipBlanks() != '>') {
            throw new Exception("Parsing error. Expected >, but got: " + c2);
        }
    }

    private void skipComment() throws Exception {
        int dashes = 2;
        while (dashes > 0) {
            char ch = this.getNextChar();
            if (ch == '-') {
                --dashes;
                continue;
            }
            dashes = 2;
        }
        char nextChar = this.getNextChar();
        if (nextChar != '>') {
            throw new Exception("Parsing error. Expected > but got: " + nextChar);
        }
    }

    private boolean checkLiteral(String literal) throws Exception {
        int length = literal.length();
        for (int i2 = 0; i2 < length; ++i2) {
            if (this.getNextChar() == literal.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    private char getNextChar() throws Exception {
        if (this.pushedBackChar != '\u0000') {
            char c2 = this.pushedBackChar;
            this.pushedBackChar = '\u0000';
            return c2;
        }
        int i2 = this.reader.read();
        if (i2 < 0) {
            throw new Exception("Parsing error. Unexpected end of data");
        }
        return (char)i2;
    }

    private void mapEntity(StringBuffer buf) throws Exception {
        char c2 = '\u0000';
        StringBuffer keyBuf = new StringBuffer();
        while ((c2 = this.getNextChar()) != ';') {
            keyBuf.append(c2);
        }
        String key = keyBuf.toString();
        if (key.charAt(0) == '#') {
            try {
                c2 = key.charAt(1) == 'x' ? (char)Integer.parseInt(key.substring(2), 16) : (char)Integer.parseInt(key.substring(1), 10);
            }
            catch (NumberFormatException e2) {
                throw new Exception("Unknown entity: " + key);
            }
            buf.append(c2);
        } else {
            char[] value = entities.get(key);
            if (value == null) {
                throw new Exception("Unknown entity: " + key);
            }
            buf.append(value);
        }
    }

    private void pushBackChar(char c2) {
        this.pushedBackChar = c2;
    }

    private void addChild(LightXMLParser child) {
        this.children.add(child);
    }

    private void setAttribute(String name, Object value) {
        this.attributes.put(name, value.toString());
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    private LightXMLParser createAnotherElement() {
        return new LightXMLParser();
    }

    private void setName(String name) {
        this.name = name;
    }

    private void emptyBuf(StringBuffer buf) {
        buf.setLength(0);
    }

    static {
        entities.put("amp", new char[]{'&'});
        entities.put("quot", new char[]{'\"'});
        entities.put("apos", new char[]{'\''});
        entities.put("lt", new char[]{'<'});
        entities.put("gt", new char[]{'>'});
    }
}

