/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.Code;
import org.aspectj.apache.bcel.classfile.CodeException;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ExceptionTable;
import org.aspectj.apache.bcel.classfile.LineNumber;
import org.aspectj.apache.bcel.classfile.LineNumberTable;
import org.aspectj.apache.bcel.classfile.LocalVariable;
import org.aspectj.apache.bcel.classfile.LocalVariableTable;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.Node;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeParamAnnos;
import org.aspectj.apache.bcel.generic.ClassGenException;
import org.aspectj.apache.bcel.generic.CodeExceptionGen;
import org.aspectj.apache.bcel.generic.FieldGenOrMethodGen;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionBranch;
import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.InstructionLV;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.apache.bcel.generic.InstructionSelect;
import org.aspectj.apache.bcel.generic.LineNumberGen;
import org.aspectj.apache.bcel.generic.LineNumberTag;
import org.aspectj.apache.bcel.generic.LocalVariableGen;
import org.aspectj.apache.bcel.generic.LocalVariableTag;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.RET;
import org.aspectj.apache.bcel.generic.Type;

public class MethodGen
extends FieldGenOrMethodGen {
    private String classname;
    private Type[] parameterTypes;
    private String[] parameterNames;
    private int maxLocals;
    private int maxStack;
    private InstructionList il;
    private boolean stripAttributes;
    private int highestLineNumber = 0;
    private List<LocalVariableGen> localVariablesList = new ArrayList<LocalVariableGen>();
    private List<LineNumberGen> lineNumbersList = new ArrayList<LineNumberGen>();
    private ArrayList<CodeExceptionGen> exceptionsList = new ArrayList();
    private ArrayList<String> exceptionsThrown = new ArrayList();
    private List<Attribute> codeAttributesList = new ArrayList<Attribute>();
    private List<AnnotationGen>[] param_annotations;
    private boolean hasParameterAnnotations = false;
    private boolean haveUnpackedParameterAnnotations = false;

    public MethodGen(int access_flags, Type return_type, Type[] arg_types, String[] arg_names, String method_name, String class_name, InstructionList il, ConstantPool cp) {
        this.modifiers = access_flags;
        this.type = return_type;
        this.parameterTypes = arg_types;
        this.parameterNames = arg_names;
        this.name = method_name;
        this.classname = class_name;
        this.il = il;
        this.cp = cp;
    }

    public int getHighestlinenumber() {
        return this.highestLineNumber;
    }

    public MethodGen(Method m4, String class_name, ConstantPool cp) {
        this(m4, class_name, cp, false);
    }

    public MethodGen(Method m4, String class_name, ConstantPool cp, boolean useTags) {
        this(m4.getModifiers(), m4.getReturnType(), m4.getArgumentTypes(), null, m4.getName(), class_name, (m4.getModifiers() & 0x500) == 0 ? new InstructionList(m4.getCode().getCode()) : null, cp);
        Attribute[] attributes;
        for (Attribute attribute : attributes = m4.getAttributes()) {
            Attribute a2 = attribute;
            if (a2 instanceof Code) {
                Attribute[] codeAttrs;
                Code code = (Code)a2;
                this.setMaxStack(code.getMaxStack());
                this.setMaxLocals(code.getMaxLocals());
                Object[] ces = code.getExceptionTable();
                InstructionHandle[] arrayOfInstructions = this.il.getInstructionsAsArray();
                if (ces != null) {
                    for (Object ce : ces) {
                        InstructionHandle end;
                        int type = ((CodeException)ce).getCatchType();
                        ObjectType catchType = null;
                        if (type > 0) {
                            String cen = m4.getConstantPool().getConstantString_CONSTANTClass(type);
                            catchType = new ObjectType(cen);
                        }
                        int end_pc = ((CodeException)ce).getEndPC();
                        int length = m4.getCode().getCode().length;
                        if (length == end_pc) {
                            end = this.il.getEnd();
                        } else {
                            end = this.il.findHandle(end_pc, arrayOfInstructions);
                            end = end.getPrev();
                        }
                        this.addExceptionHandler(this.il.findHandle(((CodeException)ce).getStartPC(), arrayOfInstructions), end, this.il.findHandle(((CodeException)ce).getHandlerPC(), arrayOfInstructions), catchType);
                    }
                }
                for (Attribute codeAttr : codeAttrs = code.getAttributes()) {
                    a2 = codeAttr;
                    if (a2 instanceof LineNumberTable) {
                        LineNumber[] ln = ((LineNumberTable)a2).getLineNumberTable();
                        if (useTags) {
                            for (Node node : ln) {
                                int lnum = ((LineNumber)node).getLineNumber();
                                if (lnum > this.highestLineNumber) {
                                    this.highestLineNumber = lnum;
                                }
                                LineNumberTag lt = new LineNumberTag(lnum);
                                this.il.findHandle(((LineNumber)node).getStartPC(), arrayOfInstructions, true).addTargeter(lt);
                            }
                            continue;
                        }
                        for (Node node : ln) {
                            this.addLineNumber(this.il.findHandle(((LineNumber)node).getStartPC(), arrayOfInstructions, true), ((LineNumber)node).getLineNumber());
                        }
                        continue;
                    }
                    if (a2 instanceof LocalVariableTable) {
                        LocalVariable[] lv;
                        if (useTags) {
                            lv = ((LocalVariableTable)a2).getLocalVariableTable();
                            for (Node node : lv) {
                                Type t2 = Type.getType(((LocalVariable)node).getSignature());
                                LocalVariableTag lvt = new LocalVariableTag(t2, ((LocalVariable)node).getSignature(), ((LocalVariable)node).getName(), ((LocalVariable)node).getIndex(), ((LocalVariable)node).getStartPC());
                                InstructionHandle start = this.il.findHandle(((LocalVariable)node).getStartPC(), arrayOfInstructions, true);
                                byte b2 = t2.getType();
                                if (b2 != 16) {
                                    int increment = t2.getSize();
                                    if (((LocalVariable)node).getIndex() + increment > this.maxLocals) {
                                        this.maxLocals = ((LocalVariable)node).getIndex() + increment;
                                    }
                                }
                                int end = ((LocalVariable)node).getStartPC() + ((LocalVariable)node).getLength();
                                do {
                                    start.addTargeter(lvt);
                                } while ((start = start.getNext()) != null && start.getPosition() < end);
                            }
                            continue;
                        }
                        lv = ((LocalVariableTable)a2).getLocalVariableTable();
                        this.removeLocalVariables();
                        for (Node node : lv) {
                            InstructionHandle start = this.il.findHandle(((LocalVariable)node).getStartPC(), arrayOfInstructions);
                            InstructionHandle end = this.il.findHandle(((LocalVariable)node).getStartPC() + ((LocalVariable)node).getLength(), arrayOfInstructions);
                            if (end != null) {
                                end = end.getPrev();
                            }
                            if (null == start) {
                                start = this.il.getStart();
                            }
                            if (null == end) {
                                end = this.il.getEnd();
                            }
                            this.addLocalVariable(((LocalVariable)node).getName(), Type.getType(((LocalVariable)node).getSignature()), ((LocalVariable)node).getIndex(), start, end);
                        }
                        continue;
                    }
                    this.addCodeAttribute(a2);
                }
                continue;
            }
            if (a2 instanceof ExceptionTable) {
                String[] names = ((ExceptionTable)a2).getExceptionNames();
                for (String s2 : names) {
                    this.addException(s2);
                }
                continue;
            }
            if (a2 instanceof RuntimeAnnos) {
                RuntimeAnnos runtimeAnnotations = (RuntimeAnnos)a2;
                List<AnnotationGen> l3 = runtimeAnnotations.getAnnotations();
                this.annotationList.addAll(l3);
                continue;
            }
            this.addAttribute(a2);
        }
    }

    public LocalVariableGen addLocalVariable(String name, Type type, int slot, InstructionHandle start, InstructionHandle end) {
        LocalVariableGen l2;
        int i2;
        int size = type.getSize();
        if (slot + size > this.maxLocals) {
            this.maxLocals = slot + size;
        }
        if ((i2 = this.localVariablesList.indexOf(l2 = new LocalVariableGen(slot, name, type, start, end))) >= 0) {
            this.localVariablesList.set(i2, l2);
        } else {
            this.localVariablesList.add(l2);
        }
        return l2;
    }

    public LocalVariableGen addLocalVariable(String name, Type type, InstructionHandle start, InstructionHandle end) {
        return this.addLocalVariable(name, type, this.maxLocals, start, end);
    }

    public void removeLocalVariable(LocalVariableGen l2) {
        this.localVariablesList.remove(l2);
    }

    public void removeLocalVariables() {
        this.localVariablesList.clear();
    }

    private static final void sort(LocalVariableGen[] vars, int l2, int r2) {
        int i2 = l2;
        int j2 = r2;
        int m4 = vars[(l2 + r2) / 2].getIndex();
        while (true) {
            if (vars[i2].getIndex() < m4) {
                ++i2;
                continue;
            }
            while (m4 < vars[j2].getIndex()) {
                --j2;
            }
            if (i2 <= j2) {
                LocalVariableGen h2 = vars[i2];
                vars[i2] = vars[j2];
                vars[j2] = h2;
                ++i2;
                --j2;
            }
            if (i2 > j2) break;
        }
        if (l2 < j2) {
            MethodGen.sort(vars, l2, j2);
        }
        if (i2 < r2) {
            MethodGen.sort(vars, i2, r2);
        }
    }

    public LocalVariableGen[] getLocalVariables() {
        int size = this.localVariablesList.size();
        LocalVariableGen[] lg = new LocalVariableGen[size];
        this.localVariablesList.toArray(lg);
        for (int i2 = 0; i2 < size; ++i2) {
            if (lg[i2].getStart() == null) {
                lg[i2].setStart(this.il.getStart());
            }
            if (lg[i2].getEnd() != null) continue;
            lg[i2].setEnd(this.il.getEnd());
        }
        if (size > 1) {
            MethodGen.sort(lg, 0, size - 1);
        }
        return lg;
    }

    public LocalVariableTable getLocalVariableTable(ConstantPool cp) {
        LocalVariableGen[] lg = this.getLocalVariables();
        int size = lg.length;
        LocalVariable[] lv = new LocalVariable[size];
        for (int i2 = 0; i2 < size; ++i2) {
            lv[i2] = lg[i2].getLocalVariable(cp);
        }
        return new LocalVariableTable(cp.addUtf8("LocalVariableTable"), 2 + lv.length * 10, lv, cp);
    }

    public LineNumberGen addLineNumber(InstructionHandle ih, int src_line) {
        LineNumberGen l2 = new LineNumberGen(ih, src_line);
        this.lineNumbersList.add(l2);
        return l2;
    }

    public void removeLineNumber(LineNumberGen l2) {
        this.lineNumbersList.remove(l2);
    }

    public void removeLineNumbers() {
        this.lineNumbersList.clear();
    }

    public LineNumberGen[] getLineNumbers() {
        LineNumberGen[] lg = new LineNumberGen[this.lineNumbersList.size()];
        this.lineNumbersList.toArray(lg);
        return lg;
    }

    public LineNumberTable getLineNumberTable(ConstantPool cp) {
        int size = this.lineNumbersList.size();
        LineNumber[] ln = new LineNumber[size];
        for (int i2 = 0; i2 < size; ++i2) {
            ln[i2] = this.lineNumbersList.get(i2).getLineNumber();
        }
        return new LineNumberTable(cp.addUtf8("LineNumberTable"), 2 + ln.length * 4, ln, cp);
    }

    public CodeExceptionGen addExceptionHandler(InstructionHandle start_pc, InstructionHandle end_pc, InstructionHandle handler_pc, ObjectType catch_type) {
        if (start_pc == null || end_pc == null || handler_pc == null) {
            throw new ClassGenException("Exception handler target is null instruction");
        }
        CodeExceptionGen c2 = new CodeExceptionGen(start_pc, end_pc, handler_pc, catch_type);
        this.exceptionsList.add(c2);
        return c2;
    }

    public void removeExceptionHandler(CodeExceptionGen c2) {
        this.exceptionsList.remove(c2);
    }

    public void removeExceptionHandlers() {
        this.exceptionsList.clear();
    }

    public CodeExceptionGen[] getExceptionHandlers() {
        CodeExceptionGen[] cg = new CodeExceptionGen[this.exceptionsList.size()];
        this.exceptionsList.toArray(cg);
        return cg;
    }

    private CodeException[] getCodeExceptions() {
        int size = this.exceptionsList.size();
        CodeException[] c_exc = new CodeException[size];
        try {
            for (int i2 = 0; i2 < size; ++i2) {
                CodeExceptionGen c2 = this.exceptionsList.get(i2);
                c_exc[i2] = c2.getCodeException(this.cp);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return c_exc;
    }

    public void addException(String class_name) {
        this.exceptionsThrown.add(class_name);
    }

    public void removeException(String c2) {
        this.exceptionsThrown.remove(c2);
    }

    public void removeExceptions() {
        this.exceptionsThrown.clear();
    }

    public String[] getExceptions() {
        String[] e2 = new String[this.exceptionsThrown.size()];
        this.exceptionsThrown.toArray(e2);
        return e2;
    }

    private ExceptionTable getExceptionTable(ConstantPool cp) {
        int size = this.exceptionsThrown.size();
        int[] ex = new int[size];
        try {
            for (int i2 = 0; i2 < size; ++i2) {
                ex[i2] = cp.addClass(this.exceptionsThrown.get(i2));
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return new ExceptionTable(cp.addUtf8("Exceptions"), 2 + 2 * size, ex, cp);
    }

    public void addCodeAttribute(Attribute a2) {
        this.codeAttributesList.add(a2);
    }

    public void addParameterAnnotationsAsAttribute(ConstantPool cp) {
        if (!this.hasParameterAnnotations) {
            return;
        }
        Attribute[] attrs = Utility.getParameterAnnotationAttributes(cp, this.param_annotations);
        if (attrs != null) {
            for (Attribute attr : attrs) {
                this.addAttribute(attr);
            }
        }
    }

    public void removeCodeAttribute(Attribute a2) {
        this.codeAttributesList.remove(a2);
    }

    public void removeCodeAttributes() {
        this.codeAttributesList.clear();
    }

    public Attribute[] getCodeAttributes() {
        Attribute[] attributes = new Attribute[this.codeAttributesList.size()];
        this.codeAttributesList.toArray(attributes);
        return attributes;
    }

    public Method getMethod() {
        String signature = this.getSignature();
        int name_index = this.cp.addUtf8(this.name);
        int signature_index = this.cp.addUtf8(signature);
        byte[] byte_code = null;
        if (this.il != null) {
            try {
                byte_code = this.il.getByteCode();
            }
            catch (Exception e2) {
                throw new IllegalStateException("Unexpected problem whilst preparing bytecode for " + this.getClassName() + "." + this.getName() + this.getSignature(), e2);
            }
        }
        LineNumberTable lnt = null;
        LocalVariableTable lvt = null;
        if (this.localVariablesList.size() > 0 && !this.stripAttributes) {
            lvt = this.getLocalVariableTable(this.cp);
            this.addCodeAttribute(lvt);
        }
        if (this.lineNumbersList.size() > 0 && !this.stripAttributes) {
            lnt = this.getLineNumberTable(this.cp);
            this.addCodeAttribute(lnt);
        }
        Attribute[] code_attrs = this.getCodeAttributes();
        int attrs_len = 0;
        for (Attribute code_attr : code_attrs) {
            attrs_len += code_attr.getLength() + 6;
        }
        CodeException[] c_exc = this.getCodeExceptions();
        int exc_len = c_exc.length * 8;
        Code code = null;
        if (this.il != null && !this.isAbstract()) {
            List<Attribute> attributes = this.getAttributes();
            for (Attribute a2 : attributes) {
                if (!(a2 instanceof Code)) continue;
                this.removeAttribute(a2);
            }
            code = new Code(this.cp.addUtf8("Code"), 8 + byte_code.length + 2 + exc_len + 2 + attrs_len, this.maxStack, this.maxLocals, byte_code, c_exc, code_attrs, this.cp);
            this.addAttribute(code);
        }
        this.addAnnotationsAsAttribute(this.cp);
        this.addParameterAnnotationsAsAttribute(this.cp);
        ExceptionTable et = null;
        if (this.exceptionsThrown.size() > 0) {
            et = this.getExceptionTable(this.cp);
            this.addAttribute(et);
        }
        Method m4 = new Method(this.modifiers, name_index, signature_index, this.getAttributesImmutable(), this.cp);
        if (lvt != null) {
            this.removeCodeAttribute(lvt);
        }
        if (lnt != null) {
            this.removeCodeAttribute(lnt);
        }
        if (code != null) {
            this.removeAttribute(code);
        }
        if (et != null) {
            this.removeAttribute(et);
        }
        return m4;
    }

    public void setMaxLocals(int m4) {
        this.maxLocals = m4;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public void setMaxStack(int m4) {
        this.maxStack = m4;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public String getClassName() {
        return this.classname;
    }

    public void setClassName(String class_name) {
        this.classname = class_name;
    }

    public void setReturnType(Type return_type) {
        this.setType(return_type);
    }

    public Type getReturnType() {
        return this.getType();
    }

    public void setArgumentTypes(Type[] arg_types) {
        this.parameterTypes = arg_types;
    }

    public Type[] getArgumentTypes() {
        return this.parameterTypes;
    }

    public void setArgumentType(int i2, Type type) {
        this.parameterTypes[i2] = type;
    }

    public Type getArgumentType(int i2) {
        return this.parameterTypes[i2];
    }

    public void setArgumentNames(String[] arg_names) {
        this.parameterNames = arg_names;
    }

    public String[] getArgumentNames() {
        if (this.parameterNames != null) {
            return (String[])this.parameterNames.clone();
        }
        return new String[0];
    }

    public void setArgumentName(int i2, String name) {
        this.parameterNames[i2] = name;
    }

    public String getArgumentName(int i2) {
        return this.parameterNames[i2];
    }

    public InstructionList getInstructionList() {
        return this.il;
    }

    public void setInstructionList(InstructionList il) {
        this.il = il;
    }

    @Override
    public String getSignature() {
        return Utility.toMethodSignature(this.type, this.parameterTypes);
    }

    public void setMaxStack() {
        this.maxStack = this.il != null ? MethodGen.getMaxStack(this.cp, this.il, this.getExceptionHandlers()) : 0;
    }

    public void setMaxLocals() {
        this.setMaxLocals(false);
    }

    public void setMaxLocals(boolean respectLocalVariableTable) {
        if (this.il != null) {
            int max;
            int n2 = max = this.isStatic() ? 0 : 1;
            if (this.parameterTypes != null) {
                for (Type parameterType : this.parameterTypes) {
                    max += parameterType.getSize();
                }
            }
            for (InstructionHandle ih = this.il.getStart(); ih != null; ih = ih.getNext()) {
                int index;
                Instruction ins = ih.getInstruction();
                if (!(ins instanceof InstructionLV) && !(ins instanceof RET) || (index = ins.getIndex() + ins.getType(this.cp).getSize()) <= max) continue;
                max = index;
            }
            if (!respectLocalVariableTable || max > this.maxLocals) {
                this.maxLocals = max;
            }
        } else if (!respectLocalVariableTable) {
            this.maxLocals = 0;
        }
    }

    public void stripAttributes(boolean flag) {
        this.stripAttributes = flag;
    }

    public static int getMaxStack(ConstantPool cp, InstructionList il, CodeExceptionGen[] et) {
        BranchStack branchTargets = new BranchStack();
        int stackDepth = 0;
        int maxStackDepth = 0;
        for (CodeExceptionGen codeExceptionGen : et) {
            InstructionHandle handlerPos = codeExceptionGen.getHandlerPC();
            if (handlerPos == null) continue;
            maxStackDepth = 1;
            branchTargets.push(handlerPos, 1);
        }
        InstructionHandle ih = il.getStart();
        while (ih != null) {
            BranchTarget bt;
            int con;
            Instruction instruction = ih.getInstruction();
            short opcode = instruction.opcode;
            int prod = instruction.produceStack(cp);
            int delta = prod - (con = instruction.consumeStack(cp));
            if ((stackDepth += delta) > maxStackDepth) {
                maxStackDepth = stackDepth;
            }
            if (instruction instanceof InstructionBranch) {
                InstructionBranch branch = (InstructionBranch)instruction;
                if (instruction instanceof InstructionSelect) {
                    InstructionHandle[] targets;
                    InstructionSelect select = (InstructionSelect)branch;
                    for (InstructionHandle target : targets = select.getTargets()) {
                        branchTargets.push(target, stackDepth);
                    }
                    ih = null;
                } else if (!branch.isIfInstruction()) {
                    if (opcode == 168 || opcode == 201) {
                        branchTargets.push(ih.getNext(), stackDepth - 1);
                    }
                    ih = null;
                }
                branchTargets.push(branch.getTarget(), stackDepth);
            } else if (opcode == 191 || opcode == 169 || opcode >= 172 && opcode <= 177) {
                ih = null;
            }
            if (ih != null) {
                ih = ih.getNext();
            }
            if (ih != null || (bt = branchTargets.pop()) == null) continue;
            ih = bt.target;
            stackDepth = bt.stackDepth;
        }
        return maxStackDepth;
    }

    public final String toString() {
        String access = Utility.accessToString(this.modifiers);
        String signature = Utility.toMethodSignature(this.type, this.parameterTypes);
        signature = Utility.methodSignatureToString(signature, this.name, access, true, this.getLocalVariableTable(this.cp));
        StringBuffer buf = new StringBuffer(signature);
        if (this.exceptionsThrown.size() > 0) {
            for (String s2 : this.exceptionsThrown) {
                buf.append("\n\t\tthrows " + s2);
            }
        }
        return buf.toString();
    }

    public List<AnnotationGen> getAnnotationsOnParameter(int i2) {
        this.ensureExistingParameterAnnotationsUnpacked();
        if (!this.hasParameterAnnotations || i2 > this.parameterTypes.length) {
            return null;
        }
        return this.param_annotations[i2];
    }

    private void ensureExistingParameterAnnotationsUnpacked() {
        if (this.haveUnpackedParameterAnnotations) {
            return;
        }
        List<Attribute> attrs = this.getAttributes();
        RuntimeParamAnnos paramAnnVisAttr = null;
        RuntimeParamAnnos paramAnnInvisAttr = null;
        for (Attribute attribute : attrs) {
            if (!(attribute instanceof RuntimeParamAnnos)) continue;
            if (!this.hasParameterAnnotations) {
                this.param_annotations = new List[this.parameterTypes.length];
                for (int j2 = 0; j2 < this.parameterTypes.length; ++j2) {
                    this.param_annotations[j2] = new ArrayList<AnnotationGen>();
                }
            }
            this.hasParameterAnnotations = true;
            RuntimeParamAnnos rpa = (RuntimeParamAnnos)attribute;
            if (rpa.areVisible()) {
                paramAnnVisAttr = rpa;
            } else {
                paramAnnInvisAttr = rpa;
            }
            for (int j3 = 0; j3 < this.parameterTypes.length; ++j3) {
                AnnotationGen[] annos;
                for (AnnotationGen anAnnotation : annos = rpa.getAnnotationsOnParameter(j3)) {
                    this.param_annotations[j3].add(anAnnotation);
                }
            }
        }
        if (paramAnnVisAttr != null) {
            this.removeAttribute(paramAnnVisAttr);
        }
        if (paramAnnInvisAttr != null) {
            this.removeAttribute(paramAnnInvisAttr);
        }
        this.haveUnpackedParameterAnnotations = true;
    }

    private List<AnnotationGen> makeMutableVersion(AnnotationGen[] mutableArray) {
        ArrayList<AnnotationGen> result = new ArrayList<AnnotationGen>();
        for (AnnotationGen annotationGen : mutableArray) {
            result.add(new AnnotationGen(annotationGen, this.getConstantPool(), false));
        }
        return result;
    }

    public void addParameterAnnotation(int parameterIndex, AnnotationGen annotation) {
        List<AnnotationGen> existingAnnotations;
        this.ensureExistingParameterAnnotationsUnpacked();
        if (!this.hasParameterAnnotations) {
            this.param_annotations = new List[this.parameterTypes.length];
            this.hasParameterAnnotations = true;
        }
        if ((existingAnnotations = this.param_annotations[parameterIndex]) != null) {
            existingAnnotations.add(annotation);
        } else {
            ArrayList<AnnotationGen> l2 = new ArrayList<AnnotationGen>();
            l2.add(annotation);
            this.param_annotations[parameterIndex] = l2;
        }
    }

    static final class BranchStack {
        Stack<BranchTarget> branchTargets = new Stack();
        Map<InstructionHandle, BranchTarget> visitedTargets = new Hashtable<InstructionHandle, BranchTarget>();

        BranchStack() {
        }

        public void push(InstructionHandle target, int stackDepth) {
            if (this.visited(target)) {
                return;
            }
            this.branchTargets.push(this.visit(target, stackDepth));
        }

        public BranchTarget pop() {
            if (!this.branchTargets.empty()) {
                BranchTarget bt = this.branchTargets.pop();
                return bt;
            }
            return null;
        }

        private final BranchTarget visit(InstructionHandle target, int stackDepth) {
            BranchTarget bt = new BranchTarget(target, stackDepth);
            this.visitedTargets.put(target, bt);
            return bt;
        }

        private final boolean visited(InstructionHandle target) {
            return this.visitedTargets.get(target) != null;
        }
    }

    static final class BranchTarget {
        InstructionHandle target;
        int stackDepth;

        BranchTarget(InstructionHandle target, int stackDepth) {
            this.target = target;
            this.stackDepth = stackDepth;
        }
    }
}

