/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ConstantDouble;
import org.aspectj.apache.bcel.classfile.ConstantFloat;
import org.aspectj.apache.bcel.classfile.ConstantInteger;
import org.aspectj.apache.bcel.classfile.ConstantLong;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;

public class SimpleElementValue
extends ElementValue {
    private int idx;

    protected SimpleElementValue(int type, int idx, ConstantPool cpGen) {
        super(type, cpGen);
        this.idx = idx;
    }

    public SimpleElementValue(int type, ConstantPool cpGen, int value) {
        super(type, cpGen);
        this.idx = cpGen.addInteger(value);
    }

    public SimpleElementValue(int type, ConstantPool cpGen, long value) {
        super(type, cpGen);
        this.idx = cpGen.addLong(value);
    }

    public SimpleElementValue(int type, ConstantPool cpGen, double value) {
        super(type, cpGen);
        this.idx = cpGen.addDouble(value);
    }

    public SimpleElementValue(int type, ConstantPool cpGen, float value) {
        super(type, cpGen);
        this.idx = cpGen.addFloat(value);
    }

    public SimpleElementValue(int type, ConstantPool cpGen, short value) {
        super(type, cpGen);
        this.idx = cpGen.addInteger(value);
    }

    public SimpleElementValue(int type, ConstantPool cpGen, byte value) {
        super(type, cpGen);
        this.idx = cpGen.addInteger(value);
    }

    public SimpleElementValue(int type, ConstantPool cpGen, char value) {
        super(type, cpGen);
        this.idx = cpGen.addInteger(value);
    }

    public SimpleElementValue(int type, ConstantPool cpGen, boolean value) {
        super(type, cpGen);
        this.idx = value ? cpGen.addInteger(1) : cpGen.addInteger(0);
    }

    public SimpleElementValue(int type, ConstantPool cpGen, String value) {
        super(type, cpGen);
        this.idx = cpGen.addUtf8(value);
    }

    public byte getValueByte() {
        if (this.type != 66) {
            throw new RuntimeException("Dont call getValueByte() on a non BYTE ElementValue");
        }
        ConstantInteger c2 = (ConstantInteger)this.cpool.getConstant(this.idx, (byte)3);
        return (byte)c2.getIntValue();
    }

    public char getValueChar() {
        if (this.type != 67) {
            throw new RuntimeException("Dont call getValueChar() on a non CHAR ElementValue");
        }
        ConstantInteger c2 = (ConstantInteger)this.cpool.getConstant(this.idx, (byte)3);
        return (char)c2.getIntValue();
    }

    public long getValueLong() {
        if (this.type != 74) {
            throw new RuntimeException("Dont call getValueLong() on a non LONG ElementValue");
        }
        ConstantLong j2 = (ConstantLong)this.cpool.getConstant(this.idx);
        return j2.getValue();
    }

    public float getValueFloat() {
        if (this.type != 70) {
            throw new RuntimeException("Dont call getValueFloat() on a non FLOAT ElementValue");
        }
        ConstantFloat f2 = (ConstantFloat)this.cpool.getConstant(this.idx);
        return f2.getValue().floatValue();
    }

    public double getValueDouble() {
        if (this.type != 68) {
            throw new RuntimeException("Dont call getValueDouble() on a non DOUBLE ElementValue");
        }
        ConstantDouble d2 = (ConstantDouble)this.cpool.getConstant(this.idx);
        return d2.getValue();
    }

    public boolean getValueBoolean() {
        if (this.type != 90) {
            throw new RuntimeException("Dont call getValueBoolean() on a non BOOLEAN ElementValue");
        }
        ConstantInteger bo = (ConstantInteger)this.cpool.getConstant(this.idx);
        return bo.getValue() != 0;
    }

    public short getValueShort() {
        if (this.type != 83) {
            throw new RuntimeException("Dont call getValueShort() on a non SHORT ElementValue");
        }
        ConstantInteger s2 = (ConstantInteger)this.cpool.getConstant(this.idx);
        return (short)s2.getIntValue();
    }

    public SimpleElementValue(SimpleElementValue value, ConstantPool cpool, boolean copyPoolEntries) {
        super(value.getElementValueType(), cpool);
        if (!copyPoolEntries) {
            this.idx = value.getIndex();
        } else {
            switch (value.getElementValueType()) {
                case 115: {
                    this.idx = cpool.addUtf8(value.getValueString());
                    break;
                }
                case 73: {
                    this.idx = cpool.addInteger(value.getValueInt());
                    break;
                }
                case 66: {
                    this.idx = cpool.addInteger(value.getValueByte());
                    break;
                }
                case 67: {
                    this.idx = cpool.addInteger(value.getValueChar());
                    break;
                }
                case 74: {
                    this.idx = cpool.addLong(value.getValueLong());
                    break;
                }
                case 70: {
                    this.idx = cpool.addFloat(value.getValueFloat());
                    break;
                }
                case 68: {
                    this.idx = cpool.addDouble(value.getValueDouble());
                    break;
                }
                case 90: {
                    if (value.getValueBoolean()) {
                        this.idx = cpool.addInteger(1);
                        break;
                    }
                    this.idx = cpool.addInteger(0);
                    break;
                }
                case 83: {
                    this.idx = cpool.addInteger(value.getValueShort());
                    break;
                }
                default: {
                    throw new RuntimeException("SimpleElementValueGen class does not know how to copy this type " + this.type);
                }
            }
        }
    }

    public int getIndex() {
        return this.idx;
    }

    public String getValueString() {
        if (this.type != 115) {
            throw new RuntimeException("Dont call getValueString() on a non STRING ElementValue");
        }
        ConstantUtf8 c2 = (ConstantUtf8)this.cpool.getConstant(this.idx);
        return c2.getValue();
    }

    public int getValueInt() {
        if (this.type != 73) {
            throw new RuntimeException("Dont call getValueString() on a non STRING ElementValue");
        }
        ConstantInteger c2 = (ConstantInteger)this.cpool.getConstant(this.idx);
        return c2.getValue();
    }

    @Override
    public String stringifyValue() {
        switch (this.type) {
            case 73: {
                ConstantInteger c2 = (ConstantInteger)this.cpool.getConstant(this.idx);
                return Integer.toString(c2.getValue());
            }
            case 74: {
                ConstantLong j2 = (ConstantLong)this.cpool.getConstant(this.idx);
                return Long.toString(j2.getValue());
            }
            case 68: {
                ConstantDouble d2 = (ConstantDouble)this.cpool.getConstant(this.idx);
                return d2.getValue().toString();
            }
            case 70: {
                ConstantFloat f2 = (ConstantFloat)this.cpool.getConstant(this.idx);
                return Float.toString(f2.getValue().floatValue());
            }
            case 83: {
                ConstantInteger s2 = (ConstantInteger)this.cpool.getConstant(this.idx);
                return Integer.toString(s2.getValue());
            }
            case 66: {
                ConstantInteger b2 = (ConstantInteger)this.cpool.getConstant(this.idx);
                return Integer.toString(b2.getValue());
            }
            case 67: {
                ConstantInteger ch = (ConstantInteger)this.cpool.getConstant(this.idx);
                return Character.toString((char)ch.getIntValue());
            }
            case 90: {
                ConstantInteger bo = (ConstantInteger)this.cpool.getConstant(this.idx);
                if (bo.getValue() == 0) {
                    return "false";
                }
                return "true";
            }
            case 115: {
                ConstantUtf8 cu8 = (ConstantUtf8)this.cpool.getConstant(this.idx);
                return cu8.getValue();
            }
        }
        throw new RuntimeException("SimpleElementValueGen class does not know how to stringify type " + this.type);
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        switch (this.type) {
            case 73: {
                ConstantInteger c2 = (ConstantInteger)this.cpool.getConstant(this.idx);
                s2.append("(int)").append(c2.getValue());
                break;
            }
            case 74: {
                ConstantLong j2 = (ConstantLong)this.cpool.getConstant(this.idx);
                s2.append("(long)").append(j2.getValue());
                break;
            }
            case 68: {
                ConstantDouble d2 = (ConstantDouble)this.cpool.getConstant(this.idx);
                s2.append("(double)").append(d2.getValue().toString());
                break;
            }
            case 70: {
                ConstantFloat f2 = (ConstantFloat)this.cpool.getConstant(this.idx);
                s2.append("(float)").append(f2.getValue());
                break;
            }
            case 83: {
                ConstantInteger ci = (ConstantInteger)this.cpool.getConstant(this.idx);
                s2.append("(short)").append(ci.getValue());
                break;
            }
            case 66: {
                ConstantInteger b2 = (ConstantInteger)this.cpool.getConstant(this.idx);
                s2.append("(byte)").append(b2.getValue());
                break;
            }
            case 67: {
                ConstantInteger ch = (ConstantInteger)this.cpool.getConstant(this.idx);
                s2.append("(char)").append((char)ch.getIntValue());
                break;
            }
            case 90: {
                ConstantInteger bo = (ConstantInteger)this.cpool.getConstant(this.idx);
                s2.append("(boolean)");
                if (bo.getValue() == 0) {
                    s2.append("false");
                    break;
                }
                s2.append("true");
                break;
            }
            case 115: {
                ConstantUtf8 cu8 = (ConstantUtf8)this.cpool.getConstant(this.idx);
                s2.append("(string)").append(cu8.getValue());
                break;
            }
            default: {
                throw new RuntimeException("SimpleElementValueGen class does not know how to stringify type " + this.type);
            }
        }
        return s2.toString();
    }

    @Override
    public void dump(DataOutputStream dos) throws IOException {
        dos.writeByte(this.type);
        switch (this.type) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                dos.writeShort(this.idx);
                break;
            }
            default: {
                throw new RuntimeException("SimpleElementValueGen doesnt know how to write out type " + this.type);
            }
        }
    }
}

