/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import io.ably.lib.http.HttpCore;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.Annotation;
import io.ably.lib.types.AnnotationAction;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Message;
import io.ably.lib.types.MessageExtras;
import io.ably.lib.types.PresenceMessage;
import io.ably.lib.types.ProtocolMessage;
import io.ably.lib.types.Summary;
import io.ably.lib.util.Base64Coder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.Set;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.Value;

public class Serialisation {
    public static final JsonParser gsonParser = new JsonParser();
    public static final GsonBuilder gsonBuilder = new GsonBuilder();
    public static final Gson gson;
    public static final MessagePack.PackerConfig msgpackPackerConfig;
    public static final MessagePack.UnpackerConfig msgpackUnpackerConfig;
    public static HttpResponseHandler<JsonElement> httpResponseHandler;
    public static HttpBodyHandler<JsonElement> httpBodyHandler;

    public static byte[] gsonToMsgpack(JsonElement json) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            MessagePacker packer = msgpackPackerConfig.newPacker(out);
            Serialisation.gsonToMsgpack(json, packer);
            packer.flush();
            return out.toByteArray();
        }
        catch (IOException e2) {
            return null;
        }
    }

    public static JsonElement msgpackToGson(byte[] bytes) {
        MessageUnpacker unpacker = msgpackUnpackerConfig.newUnpacker(bytes);
        try {
            return Serialisation.msgpackToGson(unpacker.unpackValue());
        }
        catch (IOException e2) {
            return null;
        }
    }

    public static JsonElement jsonBytesToGson(byte[] bytes) {
        return Serialisation.jsonBytesToGson(bytes, JsonElement.class);
    }

    public static <T> T jsonBytesToGson(byte[] bytes, Class<T> klass) {
        try {
            return gson.fromJson(new String(bytes, "UTF-8"), klass);
        }
        catch (UnsupportedEncodingException e2) {
            return null;
        }
    }

    public static void gsonToMsgpack(JsonElement json, MessagePacker packer) {
        if (json.isJsonArray()) {
            Serialisation.gsonToMsgpack((JsonArray)json, packer);
        } else if (json.isJsonObject()) {
            Serialisation.gsonToMsgpack((JsonObject)json, packer);
        } else if (json.isJsonNull()) {
            Serialisation.gsonToMsgpack((JsonNull)json, packer);
        } else if (json.isJsonPrimitive()) {
            Serialisation.gsonToMsgpack((JsonPrimitive)json, packer);
        } else {
            throw new RuntimeException("unreachable");
        }
    }

    private static void gsonToMsgpack(JsonArray array, MessagePacker packer) {
        try {
            packer.packArrayHeader(array.size());
            for (JsonElement elem : array) {
                Serialisation.gsonToMsgpack(elem, packer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void gsonToMsgpack(JsonObject object, MessagePacker packer) {
        try {
            Set<Map.Entry<String, JsonElement>> entries = object.entrySet();
            packer.packMapHeader(entries.size());
            for (Map.Entry<String, JsonElement> entry : entries) {
                packer.packString(entry.getKey());
                Serialisation.gsonToMsgpack(entry.getValue(), packer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void gsonToMsgpack(JsonNull n2, MessagePacker packer) {
        try {
            packer.packNil();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void gsonToMsgpack(JsonPrimitive primitive, MessagePacker packer) {
        try {
            if (primitive.isBoolean()) {
                packer.packBoolean(primitive.getAsBoolean());
            } else if (primitive.isNumber()) {
                Number number = primitive.getAsNumber();
                if (number instanceof BigDecimal || number instanceof Double) {
                    packer.packDouble(number.doubleValue());
                } else if (number instanceof Float) {
                    packer.packFloat(number.floatValue());
                } else if (number instanceof BigInteger || number instanceof Long) {
                    packer.packLong(number.longValue());
                } else if (number instanceof Integer) {
                    packer.packInt(number.intValue());
                } else if (number instanceof Short) {
                    packer.packShort(number.shortValue());
                } else if (number instanceof Byte) {
                    packer.packByte(number.byteValue());
                } else {
                    packer.packString(primitive.getAsString());
                }
            } else {
                packer.packString(primitive.getAsString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static JsonElement msgpackToGson(Value value) {
        switch (value.getValueType()) {
            case NIL: {
                return JsonNull.INSTANCE;
            }
            case BOOLEAN: {
                return new JsonPrimitive(value.asBooleanValue().getBoolean());
            }
            case INTEGER: {
                return new JsonPrimitive(value.asIntegerValue().asLong());
            }
            case FLOAT: {
                return new JsonPrimitive(value.asFloatValue().toDouble());
            }
            case STRING: {
                return new JsonPrimitive(value.asStringValue().asString());
            }
            case BINARY: {
                return new JsonPrimitive(Base64Coder.encodeToString(value.asBinaryValue().asByteArray()));
            }
            case ARRAY: {
                JsonArray array = new JsonArray();
                for (Value element : value.asArrayValue()) {
                    array.add(Serialisation.msgpackToGson(element));
                }
                return array;
            }
            case MAP: {
                JsonObject object = new JsonObject();
                for (Map.Entry<Value, Value> entry : value.asMapValue().entrySet()) {
                    object.add(entry.getKey().asStringValue().asString(), Serialisation.msgpackToGson(entry.getValue()));
                }
                return object;
            }
            case EXTENSION: {
                return null;
            }
        }
        return null;
    }

    static {
        gsonBuilder.registerTypeAdapter((Type)((Object)Message.class), new Message.Serializer());
        gsonBuilder.registerTypeAdapter((Type)((Object)MessageExtras.class), new MessageExtras.Serializer());
        gsonBuilder.registerTypeAdapter((Type)((Object)PresenceMessage.class), new PresenceMessage.Serializer());
        gsonBuilder.registerTypeAdapter((Type)((Object)PresenceMessage.Action.class), new PresenceMessage.ActionSerializer());
        gsonBuilder.registerTypeAdapter((Type)((Object)ProtocolMessage.Action.class), new ProtocolMessage.ActionSerializer());
        gsonBuilder.registerTypeAdapter((Type)((Object)Annotation.class), new Annotation.Serializer());
        gsonBuilder.registerTypeAdapter((Type)((Object)AnnotationAction.class), new Annotation.ActionSerializer());
        gsonBuilder.registerTypeAdapter((Type)((Object)Summary.class), new Summary.Serializer());
        gson = gsonBuilder.create();
        msgpackPackerConfig = "java".equals("android") ? new MessagePack.PackerConfig().withSmallStringOptimizationThreshold(Integer.MAX_VALUE) : MessagePack.DEFAULT_PACKER_CONFIG;
        msgpackUnpackerConfig = MessagePack.DEFAULT_UNPACKER_CONFIG;
        httpResponseHandler = new HttpResponseHandler();
        httpBodyHandler = new HttpBodyHandler();
    }

    public static class HttpResponseHandler<T>
    implements HttpCore.ResponseHandler<T> {
        private final Class<T> klass;
        private final FromJsonElement<T> converter;

        public HttpResponseHandler(Class<T> klass, FromJsonElement<T> converter) {
            this.klass = klass;
            this.converter = converter;
        }

        public <U extends JsonElement> HttpResponseHandler() {
            this(null, null);
        }

        @Override
        public T handleResponse(HttpCore.Response response, ErrorInfo error) throws AblyException {
            if (error != null) {
                throw AblyException.fromErrorInfo(error);
            }
            if ("application/json".equals(response.contentType)) {
                if (this.klass != null) {
                    return Serialisation.jsonBytesToGson(response.body, this.klass);
                }
                return (T)Serialisation.jsonBytesToGson(response.body);
            }
            if ("application/x-msgpack".equals(response.contentType)) {
                if (this.converter != null) {
                    return this.converter.fromJsonElement(Serialisation.msgpackToGson(response.body));
                }
                return (T)Serialisation.msgpackToGson(response.body);
            }
            throw AblyException.fromThrowable(new Exception("unknown content type " + response.contentType));
        }
    }

    public static class HttpBodyHandler<T>
    implements HttpCore.BodyHandler<T> {
        private final Class<T[]> klass;
        private final FromJsonElement<T> converter;

        public HttpBodyHandler(Class<T[]> klass, FromJsonElement<T> converter) {
            this.klass = klass;
            this.converter = converter;
        }

        public <U extends JsonElement> HttpBodyHandler() {
            this(null, null);
        }

        @Override
        public T[] handleResponseBody(String contentType, byte[] body) throws AblyException {
            JsonArray jsonArray;
            if ("application/json".equals(contentType)) {
                if (this.klass != null) {
                    return Serialisation.jsonBytesToGson(body, this.klass);
                }
                jsonArray = Serialisation.jsonBytesToGson(body, JsonArray.class);
            } else if ("application/x-msgpack".equals(contentType)) {
                jsonArray = (JsonArray)Serialisation.msgpackToGson(body);
            } else {
                throw AblyException.fromThrowable(new Exception("unknown content type " + contentType));
            }
            T[] array = this.klass.cast(Array.newInstance(this.klass.getComponentType(), jsonArray.size()));
            int i2 = 0;
            for (JsonElement elem : jsonArray) {
                array[i2] = this.converter != null ? this.converter.fromJsonElement(elem) : elem;
                ++i2;
            }
            return array;
        }
    }

    public static interface FromJsonElement<T> {
        public T fromJsonElement(JsonElement var1);
    }
}

