/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import com.google.gson.annotations.SerializedName;
import io.ably.lib.http.HttpCore;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.MessageSerializer;
import io.ably.lib.util.Log;
import io.ably.lib.util.Serialisation;
import java.io.IOException;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessageUnpacker;

public class PublishResponse {
    public ErrorInfo error;
    @SerializedName(value="channel")
    public String channelId;
    public String messageId;
    private static HttpCore.BodyHandler<PublishResponse> batchErrorBodyHandler = new BatchErrorBodyHandler();
    private static HttpCore.BodyHandler<PublishResponse> bulkResponseBodyHandler = new BulkResponseBodyHandler();
    private static final String TAG = MessageSerializer.class.getName();

    private static PublishResponse[] fromJSONArray(byte[] json) {
        return Serialisation.gson.fromJson(new String(json), PublishResponse[].class);
    }

    private static PublishResponse fromMsgpack(MessageUnpacker unpacker) throws IOException {
        return new PublishResponse().readMsgpack(unpacker);
    }

    private static PublishResponse[] fromMsgpackArray(byte[] msgpack) throws IOException {
        MessageUnpacker unpacker = Serialisation.msgpackUnpackerConfig.newUnpacker(msgpack);
        return PublishResponse.fromMsgpackArray(unpacker);
    }

    private static PublishResponse[] fromMsgpackArray(MessageUnpacker unpacker) throws IOException {
        int count = unpacker.unpackArrayHeader();
        PublishResponse[] result = new PublishResponse[count];
        for (int j2 = 0; j2 < count; ++j2) {
            result[j2] = PublishResponse.fromMsgpack(unpacker);
        }
        return result;
    }

    private PublishResponse readMsgpack(MessageUnpacker unpacker) throws IOException {
        int fieldCount = unpacker.unpackMapHeader();
        block11: for (int i2 = 0; i2 < fieldCount; ++i2) {
            String fieldName = unpacker.unpackString().intern();
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat.equals((Object)MessageFormat.NIL)) {
                unpacker.unpackNil();
                continue;
            }
            switch (fieldName) {
                case "error": {
                    this.error = ErrorInfo.fromMsgpack(unpacker);
                    continue block11;
                }
                case "channel": 
                case "channelId": {
                    this.channelId = unpacker.unpackString();
                    continue block11;
                }
                case "messageId": {
                    this.messageId = unpacker.unpackString();
                    continue block11;
                }
                default: {
                    Log.v(TAG, "Unexpected field: " + fieldName);
                    unpacker.skipValue();
                }
            }
        }
        return this;
    }

    public static HttpCore.BodyHandler<PublishResponse> getBulkPublishResponseHandler(int statusCode) {
        return statusCode < 300 ? bulkResponseBodyHandler : batchErrorBodyHandler;
    }

    private static class BatchErrorBodyHandler
    implements HttpCore.BodyHandler<PublishResponse> {
        private BatchErrorBodyHandler() {
        }

        public PublishResponse[] handleResponseBody(String contentType, byte[] body) throws AblyException {
            try {
                BatchErrorResponse response = null;
                if ("application/json".equals(contentType)) {
                    response = BatchErrorResponse.readJSON(body);
                } else if ("application/x-msgpack".equals(contentType)) {
                    response = BatchErrorResponse.readMsgpack(body);
                }
                if (response == null) {
                    return null;
                }
                if (response.error != null && response.error.code != 40020) {
                    throw AblyException.fromErrorInfo(response.error);
                }
                return response.batchResponse;
            }
            catch (IOException e2) {
                throw AblyException.fromThrowable(e2);
            }
        }
    }

    private static class BulkResponseBodyHandler
    implements HttpCore.BodyHandler<PublishResponse> {
        private BulkResponseBodyHandler() {
        }

        public PublishResponse[] handleResponseBody(String contentType, byte[] body) throws AblyException {
            try {
                if ("application/json".equals(contentType)) {
                    return PublishResponse.fromJSONArray(body);
                }
                if ("application/x-msgpack".equals(contentType)) {
                    return PublishResponse.fromMsgpackArray(body);
                }
                return null;
            }
            catch (IOException e2) {
                throw AblyException.fromThrowable(e2);
            }
        }
    }

    private static class BatchErrorResponse {
        public ErrorInfo error;
        public PublishResponse[] batchResponse;

        private BatchErrorResponse() {
        }

        static BatchErrorResponse readJSON(byte[] json) {
            return Serialisation.gson.fromJson(new String(json), BatchErrorResponse.class);
        }

        static BatchErrorResponse readMsgpack(byte[] msgpack) throws IOException {
            MessageUnpacker unpacker = Serialisation.msgpackUnpackerConfig.newUnpacker(msgpack);
            return new BatchErrorResponse().readMsgpack(unpacker);
        }

        BatchErrorResponse readMsgpack(MessageUnpacker unpacker) throws IOException {
            int fieldCount = unpacker.unpackMapHeader();
            block8: for (int i2 = 0; i2 < fieldCount; ++i2) {
                String fieldName = unpacker.unpackString().intern();
                MessageFormat fieldFormat = unpacker.getNextFormat();
                if (fieldFormat.equals((Object)MessageFormat.NIL)) {
                    unpacker.unpackNil();
                    continue;
                }
                switch (fieldName) {
                    case "error": {
                        this.error = ErrorInfo.fromMsgpack(unpacker);
                        continue block8;
                    }
                    case "batchResponse": {
                        this.batchResponse = PublishResponse.fromMsgpackArray(unpacker);
                        continue block8;
                    }
                    default: {
                        Log.v(TAG, "Unexpected field: " + fieldName);
                        unpacker.skipValue();
                    }
                }
            }
            return this;
        }
    }
}

