/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.ably.lib.types.BaseMessage;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.MessageDecodeException;
import io.ably.lib.util.Log;
import io.ably.lib.util.Serialisation;
import java.io.IOException;
import java.lang.reflect.Type;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public class PresenceMessage
extends BaseMessage
implements Cloneable {
    public Action action;
    private static final String TAG = PresenceMessage.class.getName();

    public PresenceMessage() {
    }

    public PresenceMessage(Action action, String clientId) {
        this(action, clientId, null);
    }

    public PresenceMessage(Action action, String clientId, Object data) {
        this.action = action;
        this.clientId = clientId;
        this.data = data;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("{PresenceMessage");
        super.getDetails(result);
        result.append(" action=").append(this.action.name());
        result.append('}');
        return result.toString();
    }

    public Object clone() {
        PresenceMessage result = new PresenceMessage();
        result.id = this.id;
        result.timestamp = this.timestamp;
        result.clientId = this.clientId;
        result.connectionId = this.connectionId;
        result.encoding = this.encoding;
        result.data = this.data;
        result.action = this.action;
        return result;
    }

    void writeMsgpack(MessagePacker packer) throws IOException {
        int fieldCount = super.countFields();
        packer.packMapHeader(++fieldCount);
        super.writeFields(packer);
        packer.packString("action");
        packer.packInt(this.action.getValue());
    }

    PresenceMessage readMsgpack(MessageUnpacker unpacker) throws IOException {
        int fieldCount = unpacker.unpackMapHeader();
        for (int i2 = 0; i2 < fieldCount; ++i2) {
            String fieldName = unpacker.unpackString().intern();
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat.equals((Object)MessageFormat.NIL)) {
                unpacker.unpackNil();
                continue;
            }
            if (super.readField(unpacker, fieldName, fieldFormat)) continue;
            if (fieldName.equals("action")) {
                this.action = Action.findByValue(unpacker.unpackInt());
                continue;
            }
            Log.v(TAG, "Unexpected field: " + fieldName);
            unpacker.skipValue();
        }
        return this;
    }

    static PresenceMessage fromMsgpack(MessageUnpacker unpacker) throws IOException {
        return new PresenceMessage().readMsgpack(unpacker);
    }

    public static PresenceMessage fromEncoded(JsonObject messageJsonObject, ChannelOptions channelOptions) throws MessageDecodeException {
        try {
            PresenceMessage presenceMessage = Serialisation.gson.fromJson((JsonElement)messageJsonObject, PresenceMessage.class);
            presenceMessage.decode(channelOptions);
            if (presenceMessage.action == null) {
                throw MessageDecodeException.fromDescription("Action cannot be null/empty");
            }
            return presenceMessage;
        }
        catch (Exception e2) {
            Log.e(PresenceMessage.class.getName(), e2.getMessage(), e2);
            throw MessageDecodeException.fromDescription(e2.getMessage());
        }
    }

    public static PresenceMessage fromEncoded(String messageJson, ChannelOptions channelOptions) throws MessageDecodeException {
        try {
            JsonObject jsonObject = Serialisation.gson.fromJson(messageJson, JsonObject.class);
            return PresenceMessage.fromEncoded(jsonObject, channelOptions);
        }
        catch (Exception e2) {
            Log.e(PresenceMessage.class.getName(), e2.getMessage(), e2);
            throw MessageDecodeException.fromDescription(e2.getMessage());
        }
    }

    public static PresenceMessage[] fromEncodedArray(JsonArray presenceMsgArray, ChannelOptions channelOptions) throws MessageDecodeException {
        try {
            PresenceMessage[] messages = new PresenceMessage[presenceMsgArray.size()];
            for (int index = 0; index < presenceMsgArray.size(); ++index) {
                JsonElement jsonElement = presenceMsgArray.get(index);
                if (!jsonElement.isJsonObject()) {
                    throw new JsonParseException("Not all JSON elements are of type JSON Object.");
                }
                messages[index] = PresenceMessage.fromEncoded(jsonElement.getAsJsonObject(), channelOptions);
            }
            return messages;
        }
        catch (Exception e2) {
            Log.e(PresenceMessage.class.getName(), e2.getMessage(), e2);
            throw MessageDecodeException.fromDescription(e2.getMessage());
        }
    }

    public static PresenceMessage[] fromEncodedArray(String presenceMsgArray, ChannelOptions channelOptions) throws MessageDecodeException {
        try {
            JsonArray jsonArray = Serialisation.gson.fromJson(presenceMsgArray, JsonArray.class);
            return PresenceMessage.fromEncodedArray(jsonArray, channelOptions);
        }
        catch (Exception e2) {
            Log.e(PresenceMessage.class.getName(), e2.getMessage(), e2);
            throw MessageDecodeException.fromDescription(e2.getMessage());
        }
    }

    public String memberKey() {
        return this.connectionId + ':' + this.clientId;
    }

    public static enum Action {
        absent,
        present,
        enter,
        leave,
        update;


        public int getValue() {
            return this.ordinal();
        }

        public static Action findByValue(int value) {
            return Action.values()[value];
        }
    }

    public static class Serializer
    implements JsonSerializer<PresenceMessage> {
        @Override
        public JsonElement serialize(PresenceMessage message, Type typeOfMessage, JsonSerializationContext ctx) {
            JsonObject json = BaseMessage.toJsonObject(message);
            if (message.action != null) {
                json.addProperty("action", message.action.getValue());
            }
            return json;
        }
    }

    public static class ActionSerializer
    implements JsonDeserializer<Action> {
        @Override
        public Action deserialize(JsonElement json, Type t2, JsonDeserializationContext ctx) throws JsonParseException {
            return Action.findByValue(json.getAsInt());
        }
    }
}

