/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.Message;
import io.ably.lib.types.MessageDecodeException;
import io.ably.lib.util.Log;
import io.ably.lib.util.Serialisation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public class MessageSerializer {
    private static HttpCore.BodyHandler<Message> messageResponseHandler = new MessageBodyHandler(null);
    private static final String TAG = MessageSerializer.class.getName();

    public static Message[] readMsgpackArray(MessageUnpacker unpacker) throws IOException {
        int count = unpacker.unpackArrayHeader();
        Message[] result = new Message[count];
        for (int i2 = 0; i2 < count; ++i2) {
            result[i2] = Message.fromMsgpack(unpacker);
        }
        return result;
    }

    public static Message[] readMsgpack(byte[] packed) throws AblyException {
        try {
            MessageUnpacker unpacker = Serialisation.msgpackUnpackerConfig.newUnpacker(packed);
            return MessageSerializer.readMsgpackArray(unpacker);
        }
        catch (IOException ioe) {
            throw AblyException.fromThrowable(ioe);
        }
    }

    public static HttpCore.RequestBody asMsgpackRequest(Message message) throws AblyException {
        return MessageSerializer.asMsgpackRequest(new Message[]{message});
    }

    public static HttpCore.RequestBody asMsgpackRequest(Message[] messages) {
        return new HttpUtils.ByteArrayRequestBody(MessageSerializer.writeMsgpackArray(messages), "application/x-msgpack");
    }

    public static byte[] writeMsgpackArray(Message[] messages) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            MessagePacker packer = Serialisation.msgpackPackerConfig.newPacker(out);
            MessageSerializer.writeMsgpackArray(messages, packer);
            packer.flush();
            return out.toByteArray();
        }
        catch (IOException e2) {
            return null;
        }
    }

    public static void writeMsgpackArray(Message[] messages, MessagePacker packer) {
        try {
            int count = messages.length;
            packer.packArrayHeader(count);
            for (Message message : messages) {
                message.writeMsgpack(packer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void write(Map<String, String> map, MessagePacker packer) throws IOException {
        packer.packMapHeader(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            packer.packString(entry.getKey());
            packer.packString(entry.getValue());
        }
    }

    public static Map<String, String> readStringMap(MessageUnpacker unpacker) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        int fieldCount = unpacker.unpackMapHeader();
        for (int i2 = 0; i2 < fieldCount; ++i2) {
            String fieldName = unpacker.unpackString();
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat.equals((Object)MessageFormat.NIL)) {
                unpacker.unpackNil();
                continue;
            }
            map.put(fieldName, unpacker.unpackString());
        }
        return map;
    }

    public static HttpCore.RequestBody asMsgpackRequest(Message.Batch[] pubSpecs) {
        return new HttpUtils.ByteArrayRequestBody(MessageSerializer.writeMsgpackArray(pubSpecs), "application/x-msgpack");
    }

    static byte[] writeMsgpackArray(Message.Batch[] pubSpecs) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            MessagePacker packer = Serialisation.msgpackPackerConfig.newPacker(out);
            MessageSerializer.writeMsgpackArray(pubSpecs, packer);
            packer.flush();
            return out.toByteArray();
        }
        catch (IOException e2) {
            return null;
        }
    }

    static void writeMsgpackArray(Message.Batch[] pubSpecs, MessagePacker packer) throws IOException {
        try {
            int count = pubSpecs.length;
            packer.packArrayHeader(count);
            for (Message.Batch spec : pubSpecs) {
                spec.writeMsgpack(packer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Message[] readMessagesFromJson(byte[] packed) throws MessageDecodeException {
        return Serialisation.gson.fromJson(new String(packed), Message[].class);
    }

    public static HttpCore.RequestBody asJsonRequest(Message message) throws AblyException {
        return MessageSerializer.asJsonRequest(new Message[]{message});
    }

    public static HttpCore.RequestBody asJsonRequest(Message[] messages) {
        return new HttpUtils.JsonRequestBody(Serialisation.gson.toJson(messages));
    }

    public static HttpCore.RequestBody asJSONRequest(Message.Batch[] pubSpecs) {
        return new HttpUtils.JsonRequestBody(Serialisation.gson.toJson(pubSpecs));
    }

    public static HttpCore.BodyHandler<Message> getMessageResponseHandler(ChannelOptions opts) {
        return opts == null ? messageResponseHandler : new MessageBodyHandler(opts);
    }

    private static class MessageBodyHandler
    implements HttpCore.BodyHandler<Message> {
        private ChannelOptions opts;

        MessageBodyHandler(ChannelOptions opts) {
            this.opts = opts;
        }

        public Message[] handleResponseBody(String contentType, byte[] body) throws AblyException {
            try {
                Message[] messages = null;
                if ("application/json".equals(contentType)) {
                    messages = MessageSerializer.readMessagesFromJson(body);
                } else if ("application/x-msgpack".equals(contentType)) {
                    messages = MessageSerializer.readMsgpack(body);
                }
                if (messages != null) {
                    for (Message message : messages) {
                        try {
                            message.decode(this.opts);
                        }
                        catch (MessageDecodeException e2) {
                            Log.e(TAG, e2.errorInfo.message);
                        }
                    }
                }
                return messages;
            }
            catch (MessageDecodeException e3) {
                throw AblyException.fromThrowable(e3);
            }
        }
    }
}

