/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import io.ably.lib.types.AblyException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;

public class Capability {
    private JsonObject json;
    private boolean dirty;
    private static final Gson gson = new Gson();
    private static final JsonParser gsonParser = new JsonParser();

    public static String c14n(String capability) throws AblyException {
        if (capability == null || capability.isEmpty()) {
            return null;
        }
        try {
            JsonObject json = (JsonObject)gsonParser.parse(capability);
            return new Capability(json).toString();
        }
        catch (JsonParseException | ClassCastException e2) {
            throw AblyException.fromThrowable(e2);
        }
    }

    public Capability() {
        this.json = new JsonObject();
    }

    private Capability(JsonObject json) {
        this.json = json;
        this.dirty = true;
    }

    public void addResource(String resource, String ... ops) {
        JsonArray jsonOps = (JsonArray)gson.toJsonTree(ops);
        this.json.add(resource, jsonOps);
        this.dirty = true;
    }

    public void removeResource(String resource) {
        this.json.remove(resource);
    }

    public void addOperation(String resource, String op) {
        JsonArray jsonOps = (JsonArray)this.json.get(resource);
        if (jsonOps == null) {
            jsonOps = new JsonArray();
            this.json.add(resource, jsonOps);
        }
        int opCount = jsonOps.size();
        for (int i2 = 0; i2 < opCount; ++i2) {
            if (!jsonOps.get(i2).getAsString().equals(op)) continue;
            return;
        }
        jsonOps.add(op);
        this.dirty = true;
    }

    public void removeOperation(String resource, String op) {
        JsonArray jsonOps = (JsonArray)this.json.get(resource);
        if (jsonOps == null) {
            return;
        }
        int opCount = jsonOps.size();
        for (int i2 = 0; i2 < opCount; ++i2) {
            if (!jsonOps.get(i2).getAsString().equals(op)) continue;
            if (opCount == 1) {
                this.json.remove(resource);
            } else {
                jsonOps.remove(i2);
            }
            return;
        }
    }

    public String toString() {
        if (this.dirty) {
            Set<Map.Entry<String, JsonElement>> entries = this.json.entrySet();
            if (entries.isEmpty()) {
                return "";
            }
            Object[] resources = new String[entries.size()];
            int idx = 0;
            for (Map.Entry<String, JsonElement> entry : entries) {
                resources[idx++] = entry.getKey();
            }
            Arrays.sort(resources);
            JsonObject c14nJson = new JsonObject();
            for (Object resource : resources) {
                JsonArray jsonOps = this.json.get((String)resource).getAsJsonArray();
                int count = jsonOps.size();
                Object[] ops = new String[count];
                for (int i2 = 0; i2 < count; ++i2) {
                    ops[i2] = jsonOps.get(i2).getAsString();
                }
                Arrays.sort(ops);
                c14nJson.add((String)resource, gson.toJsonTree(ops));
            }
            this.json = c14nJson;
            this.dirty = false;
        }
        return gson.toJson(this.json);
    }
}

