/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.ably.lib.types.AnnotationAction;
import io.ably.lib.types.BaseMessage;
import io.ably.lib.types.MessageDecodeException;
import io.ably.lib.types.MessageExtras;
import io.ably.lib.util.Log;
import io.ably.lib.util.Serialisation;
import java.io.IOException;
import java.lang.reflect.Type;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public class Annotation
extends BaseMessage {
    private static final String TAG = Annotation.class.getName();
    private static final String ACTION = "action";
    private static final String SERIAL = "serial";
    private static final String MESSAGE_SERIAL = "messageSerial";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String COUNT = "count";
    private static final String EXTRAS = "extras";
    public AnnotationAction action;
    public String serial;
    public String messageSerial;
    public String type;
    public String name;
    public Integer count;
    public MessageExtras extras;

    public static Annotation fromMsgpack(MessageUnpacker unpacker) throws IOException {
        return new Annotation().readMsgpack(unpacker);
    }

    void writeMsgpack(MessagePacker packer) throws IOException {
        int fieldCount = super.countFields();
        if (this.action != null) {
            ++fieldCount;
        }
        if (this.serial != null) {
            ++fieldCount;
        }
        if (this.messageSerial != null) {
            ++fieldCount;
        }
        if (this.type != null) {
            ++fieldCount;
        }
        if (this.name != null) {
            ++fieldCount;
        }
        if (this.count != null) {
            ++fieldCount;
        }
        if (this.extras != null) {
            ++fieldCount;
        }
        packer.packMapHeader(fieldCount);
        super.writeFields(packer);
        if (this.action != null) {
            packer.packString(ACTION);
            packer.packInt(this.action.ordinal());
        }
        if (this.serial != null) {
            packer.packString(SERIAL);
            packer.packString(this.serial);
        }
        if (this.messageSerial != null) {
            packer.packString(MESSAGE_SERIAL);
            packer.packString(this.messageSerial);
        }
        if (this.type != null) {
            packer.packString(TYPE);
            packer.packString(this.type);
        }
        if (this.name != null) {
            packer.packString(NAME);
            packer.packString(this.name);
        }
        if (this.count != null) {
            packer.packString(COUNT);
            packer.packInt(this.count);
        }
        if (this.extras != null) {
            packer.packString(EXTRAS);
            this.extras.write(packer);
        }
    }

    Annotation readMsgpack(MessageUnpacker unpacker) throws IOException {
        int fieldCount = unpacker.unpackMapHeader();
        for (int i2 = 0; i2 < fieldCount; ++i2) {
            String fieldName = unpacker.unpackString().intern();
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat.equals((Object)MessageFormat.NIL)) {
                unpacker.unpackNil();
                continue;
            }
            if (super.readField(unpacker, fieldName, fieldFormat)) continue;
            if (fieldName.equals(ACTION)) {
                this.action = AnnotationAction.tryFindByOrdinal(unpacker.unpackInt());
                continue;
            }
            if (fieldName.equals(SERIAL)) {
                this.serial = unpacker.unpackString();
                continue;
            }
            if (fieldName.equals(MESSAGE_SERIAL)) {
                this.messageSerial = unpacker.unpackString();
                continue;
            }
            if (fieldName.equals(TYPE)) {
                this.type = unpacker.unpackString();
                continue;
            }
            if (fieldName.equals(NAME)) {
                this.name = unpacker.unpackString();
                continue;
            }
            if (fieldName.equals(COUNT)) {
                this.count = unpacker.unpackInt();
                continue;
            }
            if (fieldName.equals(EXTRAS)) {
                this.extras = MessageExtras.read(unpacker);
                continue;
            }
            Log.v(TAG, "Unexpected field: " + fieldName);
            unpacker.skipValue();
        }
        return this;
    }

    @Override
    protected void read(JsonObject map) throws MessageDecodeException {
        super.read(map);
        Integer actionOrdinal = this.readInt(map, ACTION);
        this.action = actionOrdinal == null ? null : AnnotationAction.tryFindByOrdinal(actionOrdinal);
        this.serial = this.readString(map, SERIAL);
        this.messageSerial = this.readString(map, MESSAGE_SERIAL);
        this.type = this.readString(map, TYPE);
        this.name = this.readString(map, NAME);
        this.count = this.readInt(map, COUNT);
        JsonElement extrasElement = map.get(EXTRAS);
        if (extrasElement != null) {
            if (!extrasElement.isJsonObject()) {
                throw MessageDecodeException.fromDescription("Message extras is of type \"" + extrasElement.getClass() + "\" when expected a JSON object.");
            }
            this.extras = MessageExtras.read((JsonObject)extrasElement);
        }
    }

    public static class ActionSerializer
    implements JsonSerializer<AnnotationAction>,
    JsonDeserializer<AnnotationAction> {
        @Override
        public AnnotationAction deserialize(JsonElement json, Type t2, JsonDeserializationContext ctx) throws JsonParseException {
            return AnnotationAction.tryFindByOrdinal(json.getAsInt());
        }

        @Override
        public JsonElement serialize(AnnotationAction action, Type t2, JsonSerializationContext ctx) {
            return new JsonPrimitive(action.ordinal());
        }
    }

    public static class Serializer
    implements JsonSerializer<Annotation>,
    JsonDeserializer<Annotation> {
        @Override
        public JsonElement serialize(Annotation annotation, Type typeOfMessage, JsonSerializationContext ctx) {
            JsonObject json = BaseMessage.toJsonObject(annotation);
            if (annotation.action != null) {
                json.addProperty(Annotation.ACTION, annotation.action.ordinal());
            }
            if (annotation.serial != null) {
                json.addProperty(Annotation.SERIAL, annotation.serial);
            }
            if (annotation.messageSerial != null) {
                json.addProperty(Annotation.MESSAGE_SERIAL, annotation.messageSerial);
            }
            if (annotation.type != null) {
                json.addProperty(Annotation.TYPE, annotation.type);
            }
            if (annotation.name != null) {
                json.addProperty(Annotation.NAME, annotation.name);
            }
            if (annotation.count != null) {
                json.addProperty(Annotation.COUNT, annotation.count);
            }
            if (annotation.extras != null) {
                json.add(Annotation.EXTRAS, Serialisation.gson.toJsonTree(annotation.extras));
            }
            return json;
        }

        @Override
        public Annotation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonObject()) {
                throw new JsonParseException("Expected an object but got \"" + json.getClass() + "\".");
            }
            Annotation annotation = new Annotation();
            try {
                annotation.read((JsonObject)json);
            }
            catch (MessageDecodeException e2) {
                Log.e(TAG, e2.getMessage(), e2);
                throw new JsonParseException("Failed to deserialize Message from JSON.", e2);
            }
            return annotation;
        }
    }
}

