/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.rest;

import io.ably.lib.http.BasePaginatedQuery;
import io.ably.lib.http.Http;
import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.Annotation;
import io.ably.lib.types.AnnotationAction;
import io.ably.lib.types.AnnotationSerializer;
import io.ably.lib.types.AsyncPaginatedResult;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.ClientOptions;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Message;
import io.ably.lib.types.MessageDecodeException;
import io.ably.lib.types.PaginatedResult;
import io.ably.lib.types.Param;
import io.ably.lib.util.Crypto;
import io.ably.lib.util.Log;
import java.util.Arrays;

public class RestAnnotations {
    private static final String TAG = RestAnnotations.class.getName();
    private final String channelName;
    private final Http http;
    private final ClientOptions clientOptions;
    private final ChannelOptions channelOptions;

    public RestAnnotations(String channelName, Http http, ClientOptions clientOptions, ChannelOptions channelOptions) {
        this.channelName = channelName;
        this.http = http;
        this.clientOptions = clientOptions;
        this.channelOptions = channelOptions;
    }

    public PaginatedResult<Annotation> get(String messageSerial, Param[] params) throws AblyException {
        this.validateMessageSerial(messageSerial);
        return this.getImpl(messageSerial, params).sync();
    }

    public PaginatedResult<Annotation> get(Message message, Param[] params) throws AblyException {
        return this.get(message.serial, params);
    }

    public void getAsync(String messageSerial, Param[] params, Callback<AsyncPaginatedResult<Annotation>> callback) throws AblyException {
        this.validateMessageSerial(messageSerial);
        this.getImpl(messageSerial, params).async(callback);
    }

    public void getAsync(Message message, Param[] params, Callback<AsyncPaginatedResult<Annotation>> callback) throws AblyException {
        this.getAsync(message.serial, params, callback);
    }

    public PaginatedResult<Annotation> get(String messageSerial) throws AblyException {
        return this.get(messageSerial, null);
    }

    public PaginatedResult<Annotation> get(Message message) throws AblyException {
        return this.get(message.serial);
    }

    public void getAsync(String messageSerial, Callback<AsyncPaginatedResult<Annotation>> callback) throws AblyException {
        this.validateMessageSerial(messageSerial);
        this.getImpl(messageSerial, null).async(callback);
    }

    public void getAsync(Message message, Callback<AsyncPaginatedResult<Annotation>> callback) throws AblyException {
        this.getAsync(message.serial, callback);
    }

    public void publish(String messageSerial, Annotation annotation) throws AblyException {
        this.validateMessageSerial(messageSerial);
        this.publishImpl(messageSerial, annotation).sync();
    }

    public void publish(Message message, Annotation annotation) throws AblyException {
        this.publish(message.serial, annotation);
    }

    public void publishAsync(String messageSerial, Annotation annotation, Callback<Void> callback) throws AblyException {
        this.validateMessageSerial(messageSerial);
        this.publishImpl(messageSerial, annotation).async(callback);
    }

    public void publishAsync(Message message, Annotation annotation, Callback<Void> callback) throws AblyException {
        this.publishAsync(message.serial, annotation, callback);
    }

    public void delete(String messageSerial, Annotation annotation) throws AblyException {
        this.validateMessageSerial(messageSerial);
        this.deleteImpl(messageSerial, annotation).sync();
    }

    public void delete(Message message, Annotation annotation) throws AblyException {
        this.delete(message.serial, annotation);
    }

    public void deleteAsync(String messageSerial, Annotation annotation, Callback<Void> callback) throws AblyException {
        this.validateMessageSerial(messageSerial);
        this.deleteImpl(messageSerial, annotation).async(callback);
    }

    public void deleteAsync(Message message, Annotation annotation, Callback<Void> callback) throws AblyException {
        this.deleteAsync(message.serial, annotation, callback);
    }

    private void validateMessageSerial(String messageSerial) throws AblyException {
        if (messageSerial == null) {
            throw AblyException.fromErrorInfo(new ErrorInfo("Message serial can not be empty", 400, 40003));
        }
    }

    private String getBasePath(String messageSerial) {
        return "/channels/" + HttpUtils.encodeURIComponent(this.channelName) + "/messages/" + HttpUtils.encodeURIComponent(messageSerial) + "/annotations";
    }

    private Http.Request<Void> deleteImpl(String messageSerial, Annotation annotation) throws AblyException {
        Log.v(TAG, "delete(): annotation=" + annotation);
        annotation.action = AnnotationAction.ANNOTATION_DELETE;
        return this.sendAnnotationImpl(messageSerial, annotation);
    }

    private Http.Request<Void> publishImpl(String messageSerial, Annotation annotation) throws AblyException {
        Log.v(TAG, "publish(): annotation=" + annotation);
        annotation.action = AnnotationAction.ANNOTATION_CREATE;
        return this.sendAnnotationImpl(messageSerial, annotation);
    }

    private Http.Request<Void> sendAnnotationImpl(String messageSerial, Annotation annotation) throws AblyException {
        if (annotation.type == null) {
            throw AblyException.fromErrorInfo(new ErrorInfo("Annotation type must be specified", 400, 40000));
        }
        annotation.messageSerial = messageSerial;
        try {
            annotation.encode(this.channelOptions);
        }
        catch (MessageDecodeException e2) {
            throw AblyException.fromThrowable(e2);
        }
        if (annotation.id == null && this.clientOptions.idempotentRestPublishing) {
            annotation.id = Crypto.getRandomId();
        }
        return this.http.request((http, callback) -> {
            Annotation[] annotations = new Annotation[]{annotation};
            HttpCore.RequestBody requestBody = this.clientOptions.useBinaryProtocol ? AnnotationSerializer.asMsgpackRequest(annotations) : AnnotationSerializer.asJsonRequest(annotations);
            Param[] params = this.clientOptions.addRequestIds ? Param.array(Crypto.generateRandomRequestId()) : null;
            http.post(this.getBasePath(messageSerial), HttpUtils.defaultAcceptHeaders(this.clientOptions.useBinaryProtocol), params, requestBody, null, true, callback);
        });
    }

    private BasePaginatedQuery.ResultRequest<Annotation> getImpl(String messageSerial, Param[] initialParams) {
        Log.v(TAG, "getImpl(): params=" + Arrays.toString(initialParams));
        HttpCore.BodyHandler<Annotation> bodyHandler = AnnotationSerializer.getAnnotationResponseHandler(this.channelOptions);
        Param[] params = this.clientOptions.addRequestIds ? Param.set(initialParams, Crypto.generateRandomRequestId()) : initialParams;
        return new BasePaginatedQuery<Annotation>(this.http, this.getBasePath(messageSerial), HttpUtils.defaultAcceptHeaders(this.clientOptions.useBinaryProtocol), params, bodyHandler).get();
    }
}

