/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.rest;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ably.lib.http.HttpCore;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.util.JsonUtils;
import io.ably.lib.util.Serialisation;

public class DeviceDetails {
    public String id;
    public String platform;
    public String formFactor;
    public String clientId;
    public JsonObject metadata;
    public Push push;
    private static Serialisation.FromJsonElement<DeviceDetails> fromJsonElement = new Serialisation.FromJsonElement<DeviceDetails>(){

        @Override
        public DeviceDetails fromJsonElement(JsonElement e2) {
            return DeviceDetails.fromJsonObject((JsonObject)e2);
        }
    };
    public static HttpCore.ResponseHandler<DeviceDetails> httpResponseHandler = new Serialisation.HttpResponseHandler<DeviceDetails>(DeviceDetails.class, fromJsonElement);
    public static HttpCore.BodyHandler<DeviceDetails> httpBodyHandler = new Serialisation.HttpBodyHandler<DeviceDetails>(DeviceDetails[].class, fromJsonElement);

    public JsonObject toJsonObject() {
        JsonObject o2 = new JsonObject();
        o2.addProperty("id", this.id);
        o2.addProperty("platform", this.platform);
        o2.addProperty("formFactor", this.formFactor);
        o2.addProperty("clientId", this.clientId);
        if (this.metadata != null) {
            o2.add("metadata", this.metadata);
        }
        if (this.push != null) {
            o2.add("push", this.push.toJsonObject());
        }
        return o2;
    }

    public JsonObject pushRecipientJsonObject() {
        return JsonUtils.object().add("push", JsonUtils.object().add("recipient", this.push.recipient)).toJson();
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof DeviceDetails)) {
            return false;
        }
        DeviceDetails other = (DeviceDetails)o2;
        JsonObject thisJson = this.toJsonObject();
        JsonObject otherJson = other.toJsonObject();
        thisJson.remove("deviceSecret");
        otherJson.remove("deviceSecret");
        DeviceDetails.normalizeRecipientField(thisJson);
        DeviceDetails.normalizeRecipientField(otherJson);
        if ((this.metadata == null || this.metadata.entrySet().isEmpty()) && (other.metadata == null || other.metadata.entrySet().isEmpty())) {
            thisJson.remove("metadata");
            otherJson.remove("metadata");
        }
        return thisJson.equals(otherJson);
    }

    public String toString() {
        return this.toJsonObject().toString();
    }

    public static DeviceDetails fromJsonObject(JsonObject o2) {
        return Serialisation.gson.fromJson((JsonElement)o2, DeviceDetails.class);
    }

    private static void normalizeRecipientField(JsonObject deviceDetailsJson) {
        JsonElement push = deviceDetailsJson.get("push");
        if (push == null) {
            return;
        }
        JsonElement recipient = push.getAsJsonObject().get("recipient");
        if (recipient == null) {
            return;
        }
        JsonObject normalizedRecipient = JsonUtils.object().add("transportType", recipient.getAsJsonObject().get("transportType")).add("deviceToken", recipient.getAsJsonObject().get("deviceToken")).add("registrationToken", recipient.getAsJsonObject().get("registrationToken")).toJson();
        push.getAsJsonObject().add("recipient", normalizedRecipient);
    }

    public static class Push {
        public JsonObject recipient;
        public State state;
        public ErrorInfo errorReason;

        public JsonObject toJsonObject() {
            JsonObject o2 = new JsonObject();
            o2.add("recipient", this.recipient);
            return o2;
        }

        public static enum State {
            ACTIVE("ACTIVE"),
            FAILING("FAILING"),
            FAILED("FAILED");

            public String code;

            private State(String code) {
                this.code = code;
            }

            public int toInt() {
                State[] values2 = State.values();
                for (int i2 = 0; i2 < values2.length; ++i2) {
                    if (this != values2[i2]) continue;
                    return i2;
                }
                return -1;
            }

            public static State fromInt(int i2) {
                State[] values2 = State.values();
                if (i2 < 0 || i2 >= values2.length) {
                    return null;
                }
                return values2[i2];
            }

            public static State fromCode(String code) {
                State[] values2;
                for (State t2 : values2 = State.values()) {
                    if (!t2.code.equals(code)) continue;
                    return t2;
                }
                return null;
            }
        }
    }
}

