/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.network;

import io.ably.lib.network.HttpCall;
import io.ably.lib.network.HttpEngine;
import io.ably.lib.network.HttpEngineConfig;
import io.ably.lib.network.HttpRequest;
import io.ably.lib.network.OkHttpCall;
import io.ably.lib.network.OkHttpUtils;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.OkHttpClient;

public class OkHttpEngine
implements HttpEngine {
    private final OkHttpClient client;
    private final HttpEngineConfig config;

    public OkHttpEngine(OkHttpClient client, HttpEngineConfig config) {
        this.client = client;
        this.config = config;
    }

    @Override
    public HttpCall call(HttpRequest request) {
        Call call = this.client.newBuilder().connectTimeout(request.getHttpOpenTimeout(), TimeUnit.MILLISECONDS).readTimeout(request.getHttpReadTimeout(), TimeUnit.MILLISECONDS).build().newCall(OkHttpUtils.toOkhttpRequest(request));
        return new OkHttpCall(call);
    }

    @Override
    public boolean isUsingProxy() {
        return this.config.getProxy() != null;
    }
}

