/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.network;

import io.ably.lib.network.NotConnectedException;
import io.ably.lib.network.WebSocketClient;
import io.ably.lib.network.WebSocketEngineConfig;
import io.ably.lib.network.WebSocketListener;
import java.net.URI;
import java.nio.ByteBuffer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import org.java_websocket.WebSocket;
import org.java_websocket.exceptions.WebsocketNotConnectedException;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ServerHandshake;

public class DefaultWebSocketClient
extends org.java_websocket.client.WebSocketClient
implements WebSocketClient {
    private final WebSocketListener listener;
    private final WebSocketEngineConfig config;
    private boolean shouldExplicitlyVerifyHostname = true;

    public DefaultWebSocketClient(URI serverUri, WebSocketListener listener, WebSocketEngineConfig config) {
        super(serverUri);
        this.listener = listener;
        this.config = config;
    }

    @Override
    public void onOpen(ServerHandshake serverHandshake) {
        if (this.config.isTls() && this.shouldExplicitlyVerifyHostname && !this.isHostnameVerified(this.config.getHost())) {
            this.close();
        } else {
            this.listener.onOpen();
        }
    }

    @Override
    public void onMessage(String s2) {
        this.listener.onMessage(s2);
    }

    @Override
    public void onMessage(ByteBuffer blob) {
        this.listener.onMessage(blob);
    }

    @Override
    public void onWebsocketPing(WebSocket conn, Framedata f2) {
        super.onWebsocketPing(conn, f2);
        this.listener.onWebsocketPing();
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        this.listener.onClose(code, reason);
    }

    @Override
    public void onError(Exception e2) {
        this.listener.onError(e2);
    }

    @Override
    public void cancel(int code, String reason) {
        this.closeConnection(code, reason);
    }

    @Override
    protected void onSetSSLParameters(SSLParameters sslParameters) {
        try {
            super.onSetSSLParameters(sslParameters);
            this.shouldExplicitlyVerifyHostname = false;
        }
        catch (NoSuchMethodError exception) {
            this.shouldExplicitlyVerifyHostname = true;
            this.listener.onOldJavaVersionDetected(exception);
        }
    }

    @Override
    public void send(String text) {
        try {
            super.send(text);
        }
        catch (WebsocketNotConnectedException e2) {
            throw new NotConnectedException(e2);
        }
    }

    private boolean isHostnameVerified(String hostname) {
        SSLSession session = this.getSSLSession();
        if (HttpsURLConnection.getDefaultHostnameVerifier().verify(hostname, session)) {
            return true;
        }
        this.listener.onError(new IllegalArgumentException("Hostname verification failed, expected " + hostname + ", found " + session.getPeerHost()));
        return false;
    }
}

