/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.http;

import com.google.gson.JsonElement;
import io.ably.lib.http.HttpCore;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.Param;
import io.ably.lib.util.Serialisation;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpUtils {
    public static Map<String, String> mimeTypes = new HashMap<String, String>();
    private static final String HEX = "0123456789ABCDEF";

    public static Param[] defaultAcceptHeaders(boolean binary) {
        Param[] headers = binary ? new Param[]{new Param("Accept", "application/x-msgpack,application/json")} : new Param[]{new Param("Accept", "application/json")};
        return headers;
    }

    public static Param[] mergeHeaders(Param[] target, Param[] src) {
        HashMap<String, Param> merged = new HashMap<String, Param>();
        if (target != null) {
            for (Param param : target) {
                merged.put(param.key, param);
            }
        }
        if (src != null) {
            for (Param param : src) {
                merged.put(param.key, param);
            }
        }
        return merged.values().toArray(new Param[merged.size()]);
    }

    public static String encodeParams(String path, Param[] params) {
        StringBuilder builder = new StringBuilder(path);
        if (params != null && params.length > 0) {
            boolean first = true;
            for (Param entry : params) {
                builder.append(first ? (char)'?' : '&');
                first = false;
                builder.append(entry.key);
                builder.append('=');
                builder.append(HttpUtils.encodeURIComponent(entry.value));
            }
        }
        return builder.toString();
    }

    public static URL parseUrl(String url) throws AblyException {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e2) {
            throw AblyException.fromThrowable(e2);
        }
    }

    public static String urlWithQueryStringRemoved(String url) throws AblyException {
        try {
            URI uri = new URI(url);
            return new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, uri.getFragment()).toString();
        }
        catch (URISyntaxException e2) {
            throw AblyException.fromThrowable(e2);
        }
    }

    public static Map<String, Param> decodeParams(String query) {
        HashMap<String, Param> params = new HashMap<String, Param>();
        String[] pairs = query.split("&");
        try {
            for (String pair : pairs) {
                int idx = pair.indexOf(61);
                String key = URLDecoder.decode(pair.substring(0, idx), "UTF-8");
                String value = URLDecoder.decode(pair.substring(idx + 1), "UTF-8");
                params.put(key, new Param(key, value));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return params;
    }

    public static Map<String, Param> indexParams(Param[] paramArray) {
        HashMap<String, Param> params = new HashMap<String, Param>();
        for (Param param : paramArray) {
            params.put(param.key, param);
        }
        return params;
    }

    public static Map<String, Param> mergeParams(Map<String, Param> target, Map<String, Param> src) {
        for (Param p2 : src.values()) {
            target.put(p2.key, p2);
        }
        return target;
    }

    public static Param[] flattenParams(Map<String, Param> map) {
        Param[] result = null;
        if (map != null) {
            result = map.values().toArray(new Param[map.size()]);
        }
        return result;
    }

    public static Param[] toParamArray(Map<String, List<String>> indexedParams) {
        ArrayList<Param> params = new ArrayList<Param>();
        for (Map.Entry<String, List<String>> entry : indexedParams.entrySet()) {
            for (String value : entry.getValue()) {
                params.add(new Param(entry.getKey(), value));
            }
        }
        return params.toArray(new Param[params.size()]);
    }

    public static String getParam(Param[] params, String key) {
        String result = null;
        if (params != null) {
            for (Param p2 : params) {
                if (!key.equals(p2.key)) continue;
                result = p2.value;
                break;
            }
        }
        return result;
    }

    public static String encodeURIComponent(String str) {
        if (str == null) {
            return null;
        }
        byte[] bytes = str.getBytes(Charset.forName("UTF-8"));
        StringBuilder builder = new StringBuilder(bytes.length);
        for (byte c2 : bytes) {
            if (c2 >= 97 ? c2 <= 122 || c2 == 126 : (c2 >= 65 ? c2 <= 90 || c2 == 95 : (c2 >= 48 ? c2 <= 57 : c2 == 45 || c2 == 46))) {
                builder.append((char)c2);
                continue;
            }
            builder.append('%').append(HEX.charAt(c2 >> 4 & 0xF)).append(HEX.charAt(c2 & 0xF));
        }
        return builder.toString();
    }

    static URL buildURL(String scheme, String host, int port, String path, Param[] params) {
        StringBuilder builder = new StringBuilder(scheme).append(host).append(':').append(port).append(HttpUtils.encodeParams(path, params));
        URL result = null;
        try {
            result = new URL(builder.toString());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return result;
    }

    static URL buildURL(String uri, Param[] params) {
        URL result = null;
        try {
            result = new URL(HttpUtils.encodeParams(uri, params));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return result;
    }

    public static HttpCore.RequestBody requestBodyFromGson(JsonElement json, boolean useBinaryProtocol) {
        if (!useBinaryProtocol) {
            return new JsonRequestBody(json);
        }
        return new ByteArrayRequestBody(Serialisation.gsonToMsgpack(json), "application/x-msgpack");
    }

    static {
        mimeTypes.put("json", "application/json");
        mimeTypes.put("xml", "application/xml");
        mimeTypes.put("html", "text/html");
        mimeTypes.put("msgpack", "application/x-msgpack");
    }

    public static class JsonRequestBody
    implements HttpCore.RequestBody {
        private final String jsonText;
        private byte[] bytes;

        public JsonRequestBody(String jsonText) {
            this.jsonText = jsonText;
        }

        public JsonRequestBody(Object ob) {
            this(Serialisation.gson.toJson(ob));
        }

        @Override
        public byte[] getEncoded() {
            return this.bytes != null ? this.bytes : (this.bytes = this.jsonText.getBytes(Charset.forName("UTF-8")));
        }

        @Override
        public String getContentType() {
            return "application/json";
        }
    }

    public static class ByteArrayRequestBody
    implements HttpCore.RequestBody {
        private final byte[] bytes;
        private final String contentType;

        public ByteArrayRequestBody(byte[] bytes, String contentType) {
            this.bytes = bytes;
            this.contentType = contentType;
        }

        @Override
        public byte[] getEncoded() {
            return this.bytes;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }
    }

    public static class FormRequestBody
    implements HttpCore.RequestBody {
        private Param[] formData;

        public FormRequestBody(Param[] formData) {
            this.formData = formData;
        }

        @Override
        public byte[] getEncoded() {
            try {
                StringBuilder body = new StringBuilder();
                for (int i2 = 0; i2 < this.formData.length; ++i2) {
                    if (i2 != 0) {
                        body.append('&');
                    }
                    body.append(URLEncoder.encode(this.formData[i2].key, "UTF-8"));
                    body.append('=');
                    body.append(URLEncoder.encode(this.formData[i2].value, "UTF-8"));
                }
                return body.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e2) {
                return new byte[0];
            }
        }

        @Override
        public String getContentType() {
            return "application/x-www-form-urlencoded";
        }
    }
}

