/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.http;

import io.ably.lib.http.AsyncHttpScheduler;
import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpScheduler;
import io.ably.lib.http.SyncHttpScheduler;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ErrorInfo;

public class Http
implements AutoCloseable {
    private final AsyncHttpScheduler asyncHttp;
    private final SyncHttpScheduler syncHttp;

    public Http(AsyncHttpScheduler asyncHttp, SyncHttpScheduler syncHttp) {
        this.asyncHttp = asyncHttp;
        this.syncHttp = syncHttp;
    }

    @Override
    public void close() throws Exception {
        this.asyncHttp.close();
    }

    public Http exchangeHttpCore(HttpCore httpCore) {
        return new Http(this.asyncHttp.exchangeHttpCore(httpCore), new SyncHttpScheduler(httpCore));
    }

    public <Result> Request<Result> request(Execute<Result> execute2) {
        return new Request<Result>(execute2);
    }

    public <Result> Request<Result> failedRequest(final AblyException e2) {
        return new Request(new Execute<Result>(){

            @Override
            public void execute(HttpScheduler http, final Callback<Result> callback) throws AblyException {
                http.execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onError(e2.errorInfo);
                    }
                });
            }
        });
    }

    public class Request<Result> {
        private final Execute<Result> execute;

        Request(Execute<Result> execute2) {
            this.execute = execute2;
        }

        public Result sync() throws AblyException {
            final SyncExecuteResult result = new SyncExecuteResult();
            this.execute.execute(Http.this.syncHttp, new Callback<Result>(){

                @Override
                public void onSuccess(Result r2) {
                    result.ok = r2;
                }

                @Override
                public void onError(ErrorInfo e2) {
                    result.error = e2;
                }
            });
            if (result.error != null) {
                throw AblyException.fromErrorInfo(result.error);
            }
            return result.ok;
        }

        public void async(Callback<Result> callback) {
            try {
                this.execute.execute(Http.this.asyncHttp, callback);
            }
            catch (AblyException e2) {
                callback.onError(e2.errorInfo);
            }
        }
    }

    public static interface Execute<Result> {
        public void execute(HttpScheduler var1, Callback<Result> var2) throws AblyException;
    }

    private static class SyncExecuteResult<Result> {
        public Result ok = null;
        public ErrorInfo error = null;

        private SyncExecuteResult() {
        }
    }
}

