/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.ImmutableLongArray;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
@J2ktIncompatible
public class AtomicDoubleArray
implements Serializable {
    private static final long serialVersionUID = 0L;
    private transient AtomicLongArray longs;

    public AtomicDoubleArray(int length) {
        this.longs = new AtomicLongArray(length);
    }

    public AtomicDoubleArray(double[] array) {
        int len = array.length;
        long[] longArray = new long[len];
        for (int i2 = 0; i2 < len; ++i2) {
            longArray[i2] = Double.doubleToRawLongBits(array[i2]);
        }
        this.longs = new AtomicLongArray(longArray);
    }

    public final int length() {
        return this.longs.length();
    }

    public final double get(int i2) {
        return Double.longBitsToDouble(this.longs.get(i2));
    }

    public final void set(int i2, double newValue) {
        long next = Double.doubleToRawLongBits(newValue);
        this.longs.set(i2, next);
    }

    public final void lazySet(int i2, double newValue) {
        long next = Double.doubleToRawLongBits(newValue);
        this.longs.lazySet(i2, next);
    }

    public final double getAndSet(int i2, double newValue) {
        long next = Double.doubleToRawLongBits(newValue);
        return Double.longBitsToDouble(this.longs.getAndSet(i2, next));
    }

    public final boolean compareAndSet(int i2, double expect, double update) {
        return this.longs.compareAndSet(i2, Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update));
    }

    public final boolean weakCompareAndSet(int i2, double expect, double update) {
        return this.longs.weakCompareAndSet(i2, Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update));
    }

    @CanIgnoreReturnValue
    public final double getAndAdd(int i2, double delta) {
        return this.getAndAccumulate(i2, delta, Double::sum);
    }

    @CanIgnoreReturnValue
    public double addAndGet(int i2, double delta) {
        return this.accumulateAndGet(i2, delta, Double::sum);
    }

    @CanIgnoreReturnValue
    public final double getAndAccumulate(int i2, double x2, DoubleBinaryOperator accumulatorFunction) {
        Preconditions.checkNotNull(accumulatorFunction);
        return this.getAndUpdate(i2, oldValue -> accumulatorFunction.applyAsDouble(oldValue, x2));
    }

    @CanIgnoreReturnValue
    public final double accumulateAndGet(int i2, double x2, DoubleBinaryOperator accumulatorFunction) {
        Preconditions.checkNotNull(accumulatorFunction);
        return this.updateAndGet(i2, oldValue -> accumulatorFunction.applyAsDouble(oldValue, x2));
    }

    @CanIgnoreReturnValue
    public final double getAndUpdate(int i2, DoubleUnaryOperator updaterFunction) {
        double currentVal;
        double nextVal;
        long next;
        long current;
        while (!this.longs.compareAndSet(i2, current = this.longs.get(i2), next = Double.doubleToRawLongBits(nextVal = updaterFunction.applyAsDouble(currentVal = Double.longBitsToDouble(current))))) {
        }
        return currentVal;
    }

    @CanIgnoreReturnValue
    public final double updateAndGet(int i2, DoubleUnaryOperator updaterFunction) {
        double currentVal;
        double nextVal;
        long next;
        long current;
        while (!this.longs.compareAndSet(i2, current = this.longs.get(i2), next = Double.doubleToRawLongBits(nextVal = updaterFunction.applyAsDouble(currentVal = Double.longBitsToDouble(current))))) {
        }
        return nextVal;
    }

    public String toString() {
        int iMax = this.length() - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b2 = new StringBuilder(19 * (iMax + 1));
        b2.append('[');
        int i2 = 0;
        while (true) {
            b2.append(Double.longBitsToDouble(this.longs.get(i2)));
            if (i2 == iMax) {
                return b2.append(']').toString();
            }
            b2.append(',').append(' ');
            ++i2;
        }
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        int length = this.length();
        s2.writeInt(length);
        for (int i2 = 0; i2 < length; ++i2) {
            s2.writeDouble(this.get(i2));
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        int length = s2.readInt();
        ImmutableLongArray.Builder builder = ImmutableLongArray.builder();
        for (int i2 = 0; i2 < length; ++i2) {
            builder.add(Double.doubleToRawLongBits(s2.readDouble()));
        }
        this.longs = new AtomicLongArray(builder.build().toArray());
    }
}

