/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Node;
import com.github.benmanes.caffeine.cache.NodeFactory;
import com.github.benmanes.caffeine.cache.References;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.ReferenceQueue;
import java.util.Objects;

class FS<K, V>
extends Node<K, V>
implements NodeFactory<K, V> {
    protected static final VarHandle KEY;
    protected static final VarHandle VALUE;
    volatile References.WeakKeyReference<K> key;
    volatile V value;

    FS() {
    }

    FS(K k2, ReferenceQueue<K> referenceQueue, V v2, ReferenceQueue<V> referenceQueue2, int n2, long l2) {
        this(new References.WeakKeyReference<K>(k2, referenceQueue), v2, referenceQueue2, n2, l2);
    }

    FS(Object object, V v2, ReferenceQueue<V> referenceQueue, int n2, long l2) {
        KEY.set(this, object);
        VALUE.set(this, v2);
    }

    @Override
    public final K getKey() {
        return (K)KEY.get(this).get();
    }

    @Override
    public final Object getKeyReference() {
        return KEY.get(this);
    }

    @Override
    public final V getValue() {
        return (V)VALUE.get(this);
    }

    @Override
    public final Object getValueReference() {
        return VALUE.get(this);
    }

    @Override
    public final void setValue(V v2, ReferenceQueue<V> referenceQueue) {
        VALUE.set(this, v2);
    }

    @Override
    public final boolean containsValue(Object object) {
        return Objects.equals(object, this.getValue());
    }

    @Override
    public Node<K, V> newNode(K k2, ReferenceQueue<K> referenceQueue, V v2, ReferenceQueue<V> referenceQueue2, int n2, long l2) {
        return new FS<K, V>(k2, referenceQueue, v2, referenceQueue2, n2, l2);
    }

    @Override
    public Node<K, V> newNode(Object object, V v2, ReferenceQueue<V> referenceQueue, int n2, long l2) {
        return new FS<K, V>(object, v2, referenceQueue, n2, l2);
    }

    @Override
    public Object newLookupKey(Object object) {
        return new References.LookupKeyReference<Object>(object);
    }

    @Override
    public Object newReferenceKey(K k2, ReferenceQueue<K> referenceQueue) {
        return new References.WeakKeyReference<K>(k2, referenceQueue);
    }

    @Override
    public final boolean isAlive() {
        Object object = this.getKeyReference();
        return object != RETIRED_WEAK_KEY && object != DEAD_WEAK_KEY;
    }

    @Override
    public final boolean isRetired() {
        return this.getKeyReference() == RETIRED_WEAK_KEY;
    }

    @Override
    public final void retire() {
        KEY.set(this, RETIRED_WEAK_KEY);
    }

    @Override
    public final boolean isDead() {
        return this.getKeyReference() == DEAD_WEAK_KEY;
    }

    @Override
    public final void die() {
        VALUE.set(this, null);
        KEY.set(this, DEAD_WEAK_KEY);
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            KEY = lookup.findVarHandle(FS.class, "key", References.WeakKeyReference.class);
            VALUE = lookup.findVarHandle(FS.class, "value", Object.class);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new ExceptionInInitializerError(reflectiveOperationException);
        }
    }
}

