/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.BeanAsArrayBuilderDeserializer;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.ExternalTypeHandler;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.IgnorePropertiesUtil;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class BuilderBasedDeserializer
extends BeanDeserializerBase {
    private static final long serialVersionUID = 1L;
    protected final AnnotatedMethod _buildMethod;
    protected final JavaType _targetType;

    public BuilderBasedDeserializer(BeanDeserializerBuilder builder, BeanDescription beanDesc, JavaType targetType, BeanPropertyMap properties, Map<String, SettableBeanProperty> backRefs, Set<String> ignorableProps, boolean ignoreAllUnknown, boolean hasViews) {
        this(builder, beanDesc, targetType, properties, backRefs, ignorableProps, ignoreAllUnknown, null, hasViews);
    }

    public BuilderBasedDeserializer(BeanDeserializerBuilder builder, BeanDescription beanDesc, JavaType targetType, BeanPropertyMap properties, Map<String, SettableBeanProperty> backRefs, Set<String> ignorableProps, boolean ignoreAllUnknown, Set<String> includableProps, boolean hasViews) {
        super(builder, beanDesc, properties, backRefs, ignorableProps, ignoreAllUnknown, includableProps, hasViews);
        this._targetType = targetType;
        this._buildMethod = builder.getBuildMethod();
        if (this._objectIdReader != null) {
            throw new IllegalArgumentException("Cannot use Object Id with Builder-based deserialization (type " + beanDesc.getType() + ")");
        }
    }

    @Deprecated
    public BuilderBasedDeserializer(BeanDeserializerBuilder builder, BeanDescription beanDesc, BeanPropertyMap properties, Map<String, SettableBeanProperty> backRefs, Set<String> ignorableProps, boolean ignoreAllUnknown, boolean hasViews) {
        this(builder, beanDesc, beanDesc.getType(), properties, backRefs, ignorableProps, ignoreAllUnknown, hasViews);
    }

    protected BuilderBasedDeserializer(BuilderBasedDeserializer src) {
        this(src, src._ignoreAllUnknown);
    }

    protected BuilderBasedDeserializer(BuilderBasedDeserializer src, boolean ignoreAllUnknown) {
        super((BeanDeserializerBase)src, ignoreAllUnknown);
        this._buildMethod = src._buildMethod;
        this._targetType = src._targetType;
    }

    protected BuilderBasedDeserializer(BuilderBasedDeserializer src, NameTransformer unwrapper) {
        super((BeanDeserializerBase)src, unwrapper);
        this._buildMethod = src._buildMethod;
        this._targetType = src._targetType;
    }

    public BuilderBasedDeserializer(BuilderBasedDeserializer src, ObjectIdReader oir) {
        super((BeanDeserializerBase)src, oir);
        this._buildMethod = src._buildMethod;
        this._targetType = src._targetType;
    }

    public BuilderBasedDeserializer(BuilderBasedDeserializer src, Set<String> ignorableProps) {
        this(src, ignorableProps, (Set<String>)src._includableProps);
    }

    public BuilderBasedDeserializer(BuilderBasedDeserializer src, Set<String> ignorableProps, Set<String> includableProps) {
        super(src, ignorableProps, includableProps);
        this._buildMethod = src._buildMethod;
        this._targetType = src._targetType;
    }

    public BuilderBasedDeserializer(BuilderBasedDeserializer src, BeanPropertyMap props) {
        super((BeanDeserializerBase)src, props);
        this._buildMethod = src._buildMethod;
        this._targetType = src._targetType;
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer unwrapper) {
        return new BuilderBasedDeserializer(this, unwrapper);
    }

    @Override
    public BeanDeserializerBase withObjectIdReader(ObjectIdReader oir) {
        return new BuilderBasedDeserializer(this, oir);
    }

    @Override
    public BeanDeserializerBase withByNameInclusion(Set<String> ignorableProps, Set<String> includableProps) {
        return new BuilderBasedDeserializer(this, ignorableProps, includableProps);
    }

    @Override
    public BeanDeserializerBase withIgnoreAllUnknown(boolean ignoreUnknown) {
        return new BuilderBasedDeserializer(this, ignoreUnknown);
    }

    @Override
    public BeanDeserializerBase withBeanProperties(BeanPropertyMap props) {
        return new BuilderBasedDeserializer(this, props);
    }

    @Override
    protected BeanDeserializerBase asArrayDeserializer() {
        SettableBeanProperty[] props = this._beanProperties.getPropertiesInInsertionOrder();
        return new BeanAsArrayBuilderDeserializer(this, this._targetType, props, this._buildMethod);
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig config) {
        return Boolean.FALSE;
    }

    protected Object finishBuild(DeserializationContext ctxt, Object builder) throws IOException {
        if (null == this._buildMethod) {
            return builder;
        }
        try {
            return this._buildMethod.getMember().invoke(builder, (Object[])null);
        }
        catch (Exception e2) {
            return this.wrapInstantiationProblem(e2, ctxt);
        }
    }

    @Override
    public Object deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (p2.isExpectedStartObjectToken()) {
            JsonToken t2 = p2.nextToken();
            if (this._vanillaProcessing) {
                return this.finishBuild(ctxt, this.vanillaDeserialize(p2, ctxt, t2));
            }
            return this.finishBuild(ctxt, this.deserializeFromObject(p2, ctxt));
        }
        switch (p2.currentTokenId()) {
            case 6: {
                return this.finishBuild(ctxt, this.deserializeFromString(p2, ctxt));
            }
            case 7: {
                return this.finishBuild(ctxt, this.deserializeFromNumber(p2, ctxt));
            }
            case 8: {
                return this.finishBuild(ctxt, this.deserializeFromDouble(p2, ctxt));
            }
            case 12: {
                return p2.getEmbeddedObject();
            }
            case 9: 
            case 10: {
                return this.finishBuild(ctxt, this.deserializeFromBoolean(p2, ctxt));
            }
            case 3: {
                return this._deserializeFromArray(p2, ctxt);
            }
            case 2: 
            case 5: {
                return this.finishBuild(ctxt, this.deserializeFromObject(p2, ctxt));
            }
        }
        return ctxt.handleUnexpectedToken(this.getValueType(ctxt), p2);
    }

    @Override
    public Object deserialize(JsonParser p2, DeserializationContext ctxt, Object value) throws IOException {
        Class<?> instRawType;
        JavaType valueType = this._targetType;
        Class<?> builderRawType = this.handledType();
        if (builderRawType.isAssignableFrom(instRawType = value.getClass())) {
            return ctxt.reportBadDefinition(valueType, String.format("Deserialization of %s by passing existing Builder (%s) instance not supported", valueType, builderRawType.getName()));
        }
        return ctxt.reportBadDefinition(valueType, String.format("Deserialization of %s by passing existing instance (of %s) not supported", valueType, instRawType.getName()));
    }

    private final Object vanillaDeserialize(JsonParser p2, DeserializationContext ctxt, JsonToken t2) throws IOException {
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        while (p2.currentToken() == JsonToken.FIELD_NAME) {
            String propName = p2.currentName();
            p2.nextToken();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            if (prop != null) {
                try {
                    bean = prop.deserializeSetAndReturn(p2, ctxt, bean);
                }
                catch (Exception e2) {
                    this.wrapAndThrow(e2, bean, propName, ctxt);
                }
            } else {
                this.handleUnknownVanilla(p2, ctxt, bean, propName);
            }
            p2.nextToken();
        }
        return bean;
    }

    @Override
    public Object deserializeFromObject(JsonParser p2, DeserializationContext ctxt) throws IOException {
        Class<?> view;
        if (this._nonStandardCreation) {
            if (this._unwrappedPropertyHandler != null) {
                return this.deserializeWithUnwrapped(p2, ctxt);
            }
            if (this._externalTypeIdHandler != null) {
                return this.deserializeWithExternalTypeId(p2, ctxt);
            }
            return this.deserializeFromObjectUsingNonDefault(p2, ctxt);
        }
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        if (this._needViewProcesing && (view = ctxt.getActiveView()) != null) {
            return this.deserializeWithView(p2, ctxt, bean, view);
        }
        while (p2.currentToken() == JsonToken.FIELD_NAME) {
            String propName = p2.currentName();
            p2.nextToken();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            if (prop != null) {
                try {
                    bean = prop.deserializeSetAndReturn(p2, ctxt, bean);
                }
                catch (Exception e2) {
                    this.wrapAndThrow(e2, bean, propName, ctxt);
                }
            } else {
                this.handleUnknownVanilla(p2, ctxt, bean, propName);
            }
            p2.nextToken();
        }
        return bean;
    }

    @Override
    protected Object _deserializeUsingPropertyBased(JsonParser p2, DeserializationContext ctxt) throws IOException {
        Object builder;
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer = creator.startBuilding(p2, ctxt, this._objectIdReader);
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        TokenBuffer unknown = null;
        JsonToken t2 = p2.currentToken();
        while (t2 == JsonToken.FIELD_NAME) {
            block22: {
                String propName = p2.currentName();
                p2.nextToken();
                SettableBeanProperty creatorProp = creator.findCreatorProperty(propName);
                if (!buffer.readIdProperty(propName) || creatorProp != null) {
                    if (creatorProp != null) {
                        if (activeView != null && !creatorProp.visibleInView(activeView)) {
                            p2.skipChildren();
                        } else if (buffer.assignParameter(creatorProp, creatorProp.deserialize(p2, ctxt))) {
                            Object builder2;
                            p2.nextToken();
                            try {
                                builder2 = creator.build(ctxt, buffer);
                            }
                            catch (Exception e2) {
                                this.wrapAndThrow(e2, this._beanType.getRawClass(), propName, ctxt);
                                break block22;
                            }
                            if (builder2.getClass() != this._beanType.getRawClass()) {
                                return this.handlePolymorphic(p2, ctxt, builder2, unknown);
                            }
                            if (unknown != null) {
                                builder2 = this.handleUnknownProperties(ctxt, builder2, unknown);
                            }
                            return this._deserialize(p2, ctxt, builder2);
                        }
                    } else {
                        SettableBeanProperty prop = this._beanProperties.find(propName);
                        if (prop != null) {
                            buffer.bufferProperty(prop, prop.deserialize(p2, ctxt));
                        } else if (IgnorePropertiesUtil.shouldIgnore(propName, this._ignorableProps, this._includableProps)) {
                            this.handleIgnoredProperty(p2, ctxt, this.handledType(), propName);
                        } else if (this._anySetter != null) {
                            buffer.bufferAnyProperty(this._anySetter, propName, this._anySetter.deserialize(p2, ctxt));
                        } else {
                            if (unknown == null) {
                                unknown = ctxt.bufferForInputBuffering(p2);
                            }
                            unknown.writeFieldName(propName);
                            unknown.copyCurrentStructure(p2);
                        }
                    }
                }
            }
            t2 = p2.nextToken();
        }
        try {
            builder = creator.build(ctxt, buffer);
        }
        catch (Exception e3) {
            builder = this.wrapInstantiationProblem(e3, ctxt);
        }
        if (unknown != null) {
            if (builder.getClass() != this._beanType.getRawClass()) {
                return this.handlePolymorphic(null, ctxt, builder, unknown);
            }
            return this.handleUnknownProperties(ctxt, builder, unknown);
        }
        return builder;
    }

    protected final Object _deserialize(JsonParser p2, DeserializationContext ctxt, Object builder) throws IOException {
        Class<?> view;
        if (this._injectables != null) {
            this.injectValues(ctxt, builder);
        }
        if (this._unwrappedPropertyHandler != null) {
            if (p2.hasToken(JsonToken.START_OBJECT)) {
                p2.nextToken();
            }
            TokenBuffer tokens = ctxt.bufferForInputBuffering(p2);
            tokens.writeStartObject();
            return this.deserializeWithUnwrapped(p2, ctxt, builder, tokens);
        }
        if (this._externalTypeIdHandler != null) {
            return this.deserializeWithExternalTypeId(p2, ctxt, builder);
        }
        if (this._needViewProcesing && (view = ctxt.getActiveView()) != null) {
            return this.deserializeWithView(p2, ctxt, builder, view);
        }
        JsonToken t2 = p2.currentToken();
        if (t2 == JsonToken.START_OBJECT) {
            t2 = p2.nextToken();
        }
        while (t2 == JsonToken.FIELD_NAME) {
            String propName = p2.currentName();
            p2.nextToken();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            if (prop != null) {
                try {
                    builder = prop.deserializeSetAndReturn(p2, ctxt, builder);
                }
                catch (Exception e2) {
                    this.wrapAndThrow(e2, builder, propName, ctxt);
                }
            } else {
                this.handleUnknownVanilla(p2, ctxt, builder, propName);
            }
            t2 = p2.nextToken();
        }
        return builder;
    }

    @Override
    protected Object _deserializeFromArray(JsonParser p2, DeserializationContext ctxt) throws IOException {
        JsonDeserializer delegateDeser = this._arrayDelegateDeserializer;
        if (delegateDeser != null || (delegateDeser = this._delegateDeserializer) != null) {
            Object builder = this._valueInstantiator.createUsingArrayDelegate(ctxt, delegateDeser.deserialize(p2, ctxt));
            if (this._injectables != null) {
                this.injectValues(ctxt, builder);
            }
            return this.finishBuild(ctxt, builder);
        }
        CoercionAction act = this._findCoercionFromEmptyArray(ctxt);
        boolean unwrap2 = ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS);
        if (unwrap2 || act != CoercionAction.Fail) {
            JsonToken t2 = p2.nextToken();
            if (t2 == JsonToken.END_ARRAY) {
                switch (act) {
                    case AsEmpty: {
                        return this.getEmptyValue(ctxt);
                    }
                    case AsNull: 
                    case TryConvert: {
                        return this.getNullValue(ctxt);
                    }
                }
                return ctxt.handleUnexpectedToken(this.getValueType(ctxt), JsonToken.START_ARRAY, p2, null, new Object[0]);
            }
            if (unwrap2) {
                Object value = this.deserialize(p2, ctxt);
                if (p2.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(p2, ctxt);
                }
                return value;
            }
        }
        return ctxt.handleUnexpectedToken(this.getValueType(ctxt), p2);
    }

    protected final Object deserializeWithView(JsonParser p2, DeserializationContext ctxt, Object bean, Class<?> activeView) throws IOException {
        JsonToken t2 = p2.currentToken();
        while (t2 == JsonToken.FIELD_NAME) {
            String propName = p2.currentName();
            p2.nextToken();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            if (prop != null) {
                if (!prop.visibleInView(activeView)) {
                    p2.skipChildren();
                } else {
                    try {
                        bean = prop.deserializeSetAndReturn(p2, ctxt, bean);
                    }
                    catch (Exception e2) {
                        this.wrapAndThrow(e2, bean, propName, ctxt);
                    }
                }
            } else {
                this.handleUnknownVanilla(p2, ctxt, bean, propName);
            }
            t2 = p2.nextToken();
        }
        return bean;
    }

    protected Object deserializeWithUnwrapped(JsonParser p2, DeserializationContext ctxt) throws IOException {
        Class<?> activeView;
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(p2, ctxt));
        }
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithUnwrapped(p2, ctxt);
        }
        TokenBuffer tokens = ctxt.bufferForInputBuffering(p2);
        tokens.writeStartObject();
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        Class<?> clazz = activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        while (p2.currentToken() == JsonToken.FIELD_NAME) {
            String propName = p2.currentName();
            p2.nextToken();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            if (prop != null) {
                if (activeView != null && !prop.visibleInView(activeView)) {
                    p2.skipChildren();
                } else {
                    try {
                        bean = prop.deserializeSetAndReturn(p2, ctxt, bean);
                    }
                    catch (Exception e2) {
                        this.wrapAndThrow(e2, bean, propName, ctxt);
                    }
                }
            } else if (IgnorePropertiesUtil.shouldIgnore(propName, this._ignorableProps, this._includableProps)) {
                this.handleIgnoredProperty(p2, ctxt, bean, propName);
            } else {
                tokens.writeFieldName(propName);
                tokens.copyCurrentStructure(p2);
                if (this._anySetter != null) {
                    try {
                        this._anySetter.deserializeAndSet(p2, ctxt, bean, propName);
                    }
                    catch (Exception e3) {
                        this.wrapAndThrow(e3, bean, propName, ctxt);
                    }
                }
            }
            p2.nextToken();
        }
        tokens.writeEndObject();
        return this._unwrappedPropertyHandler.processUnwrapped(p2, ctxt, bean, tokens);
    }

    protected Object deserializeUsingPropertyBasedWithUnwrapped(JsonParser p2, DeserializationContext ctxt) throws IOException {
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer = creator.startBuilding(p2, ctxt, this._objectIdReader);
        TokenBuffer tokens = ctxt.bufferForInputBuffering(p2);
        tokens.writeStartObject();
        Object builder = null;
        JsonToken t2 = p2.currentToken();
        while (t2 == JsonToken.FIELD_NAME) {
            block16: {
                String propName = p2.currentName();
                p2.nextToken();
                SettableBeanProperty creatorProp = creator.findCreatorProperty(propName);
                if (!buffer.readIdProperty(propName) || creatorProp != null) {
                    if (creatorProp != null) {
                        if (buffer.assignParameter(creatorProp, creatorProp.deserialize(p2, ctxt))) {
                            t2 = p2.nextToken();
                            try {
                                builder = creator.build(ctxt, buffer);
                            }
                            catch (Exception e2) {
                                this.wrapAndThrow(e2, this._beanType.getRawClass(), propName, ctxt);
                                break block16;
                            }
                            if (builder.getClass() != this._beanType.getRawClass()) {
                                return this.handlePolymorphic(p2, ctxt, builder, tokens);
                            }
                            return this.deserializeWithUnwrapped(p2, ctxt, builder, tokens);
                        }
                    } else {
                        SettableBeanProperty prop = this._beanProperties.find(propName);
                        if (prop != null) {
                            buffer.bufferProperty(prop, prop.deserialize(p2, ctxt));
                        } else if (IgnorePropertiesUtil.shouldIgnore(propName, this._ignorableProps, this._includableProps)) {
                            this.handleIgnoredProperty(p2, ctxt, this.handledType(), propName);
                        } else {
                            tokens.writeFieldName(propName);
                            tokens.copyCurrentStructure(p2);
                            if (this._anySetter != null) {
                                buffer.bufferAnyProperty(this._anySetter, propName, this._anySetter.deserialize(p2, ctxt));
                            }
                        }
                    }
                }
            }
            t2 = p2.nextToken();
        }
        tokens.writeEndObject();
        if (builder == null) {
            try {
                builder = creator.build(ctxt, buffer);
            }
            catch (Exception e3) {
                return this.wrapInstantiationProblem(e3, ctxt);
            }
        }
        return this._unwrappedPropertyHandler.processUnwrapped(p2, ctxt, builder, tokens);
    }

    protected Object deserializeWithUnwrapped(JsonParser p2, DeserializationContext ctxt, Object builder, TokenBuffer tokens) throws IOException {
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        JsonToken t2 = p2.currentToken();
        while (t2 == JsonToken.FIELD_NAME) {
            String propName = p2.currentName();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            p2.nextToken();
            if (prop != null) {
                if (activeView != null && !prop.visibleInView(activeView)) {
                    p2.skipChildren();
                } else {
                    try {
                        builder = prop.deserializeSetAndReturn(p2, ctxt, builder);
                    }
                    catch (Exception e2) {
                        this.wrapAndThrow(e2, builder, propName, ctxt);
                    }
                }
            } else if (IgnorePropertiesUtil.shouldIgnore(propName, this._ignorableProps, this._includableProps)) {
                this.handleIgnoredProperty(p2, ctxt, builder, propName);
            } else {
                tokens.writeFieldName(propName);
                tokens.copyCurrentStructure(p2);
                if (this._anySetter != null) {
                    this._anySetter.deserializeAndSet(p2, ctxt, builder, propName);
                }
            }
            t2 = p2.nextToken();
        }
        tokens.writeEndObject();
        return this._unwrappedPropertyHandler.processUnwrapped(p2, ctxt, builder, tokens);
    }

    protected Object deserializeWithExternalTypeId(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithExternalTypeId(p2, ctxt);
        }
        return this.deserializeWithExternalTypeId(p2, ctxt, this._valueInstantiator.createUsingDefault(ctxt));
    }

    protected Object deserializeWithExternalTypeId(JsonParser p2, DeserializationContext ctxt, Object bean) throws IOException {
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        ExternalTypeHandler ext = this._externalTypeIdHandler.start();
        JsonToken t2 = p2.currentToken();
        while (t2 == JsonToken.FIELD_NAME) {
            String propName = p2.currentName();
            t2 = p2.nextToken();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            if (prop != null) {
                if (t2.isScalarValue()) {
                    ext.handleTypePropertyValue(p2, ctxt, propName, bean);
                }
                if (activeView != null && !prop.visibleInView(activeView)) {
                    p2.skipChildren();
                } else {
                    try {
                        bean = prop.deserializeSetAndReturn(p2, ctxt, bean);
                    }
                    catch (Exception e2) {
                        this.wrapAndThrow(e2, bean, propName, ctxt);
                    }
                }
            } else if (IgnorePropertiesUtil.shouldIgnore(propName, this._ignorableProps, this._includableProps)) {
                this.handleIgnoredProperty(p2, ctxt, bean, propName);
            } else if (!ext.handlePropertyValue(p2, ctxt, propName, bean)) {
                if (this._anySetter != null) {
                    try {
                        this._anySetter.deserializeAndSet(p2, ctxt, bean, propName);
                    }
                    catch (Exception e3) {
                        this.wrapAndThrow(e3, bean, propName, ctxt);
                    }
                } else {
                    this.handleUnknownProperty(p2, ctxt, bean, propName);
                }
            }
            t2 = p2.nextToken();
        }
        return ext.complete(p2, ctxt, bean);
    }

    protected Object deserializeUsingPropertyBasedWithExternalTypeId(JsonParser p2, DeserializationContext ctxt) throws IOException {
        JavaType t2 = this._targetType;
        return ctxt.reportBadDefinition(t2, String.format("Deserialization (of %s) with Builder, External type id, @JsonCreator not yet implemented", t2));
    }
}

