/*
 * Decompiled with CFR 0.152.
 */
package com.davidehrmann.vcdiff.io;

import com.davidehrmann.vcdiff.VCDiffEncoderBuilder;
import com.davidehrmann.vcdiff.VCDiffStreamingEncoder;
import com.davidehrmann.vcdiff.util.Objects;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class VCDiffOutputStream
extends FilterOutputStream {
    private volatile boolean started = false;
    private volatile boolean closed = false;
    private volatile long bytesWritten = 0L;
    private final VCDiffStreamingEncoder<OutputStream> encoder;

    public VCDiffOutputStream(OutputStream out, byte[] dictionary, boolean targetMatches, boolean interleaved, boolean checksum) {
        super(out);
        this.encoder = VCDiffEncoderBuilder.builder().withDictionary(dictionary).withTargetMatches(targetMatches).withInterleaving(interleaved).withChecksum(checksum).buildStreaming();
    }

    public VCDiffOutputStream(OutputStream out, VCDiffStreamingEncoder<OutputStream> encoder) {
        super(out);
        this.encoder = Objects.requireNotNull(encoder, "encoder was null");
    }

    @Override
    public void write(int b2) throws IOException {
        this.write(new byte[]{(byte)b2}, 0, 1);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("OutputStream closed");
        }
        if (!this.started) {
            this.started = true;
            this.encoder.startEncoding(this.out);
        }
        try {
            this.encoder.encodeChunk(b2, off, len, this.out);
        }
        catch (IOException e2) {
            throw new IOException("Error trying to encode data chunk at offset " + this.bytesWritten, e2);
        }
        this.bytesWritten += (long)len;
    }

    @Override
    public void flush() throws IOException {
        super.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.started) {
                this.started = true;
                this.encoder.startEncoding(this.out);
            }
            if (!this.closed) {
                this.closed = true;
                this.encoder.finishEncoding(this.out);
            }
        }
        finally {
            super.close();
        }
    }
}

