/*
 * Decompiled with CFR 0.152.
 */
package com.davidehrmann.vcdiff.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicLong;

public class CountingOutputStream
extends FilterOutputStream {
    private final AtomicLong bytesWritten = new AtomicLong();

    public CountingOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b2) throws IOException {
        super.write(b2);
        this.bytesWritten.getAndIncrement();
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        this.out.write(b2, off, len);
        this.bytesWritten.getAndAdd(len);
    }

    public long getBytesWritten() {
        return this.bytesWritten.get();
    }
}

