/*
 * Decompiled with CFR 0.152.
 */
package com.davidehrmann.vcdiff.engine;

import com.davidehrmann.vcdiff.VCDiffCodeTableWriter;
import com.davidehrmann.vcdiff.VCDiffFormatExtension;
import com.davidehrmann.vcdiff.VCDiffStreamingEncoder;
import com.davidehrmann.vcdiff.engine.HashedDictionary;
import com.davidehrmann.vcdiff.engine.VCDiffEngine;
import com.davidehrmann.vcdiff.util.ZeroInitializedAdler32;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.zip.Adler32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCDiffStreamingEncoderImpl<OUT>
implements VCDiffStreamingEncoder<OUT> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCDiffStreamingEncoderImpl.class);
    protected final VCDiffEngine engine;
    protected final EnumSet<VCDiffFormatExtension> formatExtensions;
    protected final boolean lookForTargetMatches;
    protected final VCDiffCodeTableWriter<OUT> coder;
    protected boolean encodeChunkAllowed;

    public VCDiffStreamingEncoderImpl(VCDiffCodeTableWriter<OUT> coder, HashedDictionary dictionary, EnumSet<VCDiffFormatExtension> format_extensions, boolean look_for_target_matches) {
        this.engine = dictionary.engine();
        this.formatExtensions = format_extensions.clone();
        this.lookForTargetMatches = look_for_target_matches;
        this.coder = coder;
    }

    @Override
    public void startEncoding(OUT out) throws IOException {
        this.coder.init(this.engine.dictionary_size());
        this.coder.writeHeader(out, this.formatExtensions);
        this.encodeChunkAllowed = true;
    }

    @Override
    public void encodeChunk(byte[] data, int offset, int length, OUT out) throws IOException {
        if (!this.encodeChunkAllowed) {
            throw new IllegalStateException("encodeChunk called before startEncoding");
        }
        if (this.formatExtensions.contains((Object)VCDiffFormatExtension.GOOGLE_CHECKSUM)) {
            ZeroInitializedAdler32 adler32 = new ZeroInitializedAdler32();
            ((Adler32)adler32).update(data, offset, length);
            this.coder.addChecksum((int)((Adler32)adler32).getValue());
        }
        this.engine.Encode(ByteBuffer.wrap(data, offset, length).slice(), this.lookForTargetMatches, out, this.coder);
    }

    @Override
    public void encodeChunk(byte[] data, OUT out) throws IOException {
        this.encodeChunk(data, 0, data.length, out);
    }

    @Override
    public void finishEncoding(OUT out) throws IOException {
        if (!this.encodeChunkAllowed) {
            throw new IllegalStateException("finishEncoding called before startEncoding");
        }
        this.encodeChunkAllowed = false;
        this.coder.finishEncoding(out);
    }
}

