/*
 * Decompiled with CFR 0.152.
 */
package com.davidehrmann.vcdiff.engine;

import com.davidehrmann.vcdiff.engine.VCDiffAddressCache;
import com.davidehrmann.vcdiff.engine.VCDiffCodeTableData;
import java.util.Arrays;

class VCDiffInstructionMap {
    public static final VCDiffInstructionMap DEFAULT_INSTRUCTION_MAP = new VCDiffInstructionMap(VCDiffCodeTableData.kDefaultCodeTableData, VCDiffAddressCache.DefaultLastMode());
    private final FirstInstructionMap first_instruction_map_;
    private final SecondInstructionMap second_instruction_map_;

    public VCDiffInstructionMap(VCDiffCodeTableData code_table_data, byte max_mode) {
        int opcode;
        this.first_instruction_map_ = new FirstInstructionMap(3 + max_mode + 1, VCDiffInstructionMap.FindMaxSize(code_table_data.size1));
        this.second_instruction_map_ = new SecondInstructionMap(3 + max_mode + 1, VCDiffInstructionMap.FindMaxSize(code_table_data.size2));
        for (opcode = 0; opcode < 256; ++opcode) {
            if (code_table_data.inst2[opcode] == 0) {
                this.first_instruction_map_.Add(code_table_data.inst1[opcode], code_table_data.size1[opcode], code_table_data.mode1[opcode], (byte)opcode);
                continue;
            }
            if (code_table_data.inst1[opcode] != 0) continue;
            this.first_instruction_map_.Add(code_table_data.inst2[opcode], code_table_data.size2[opcode], code_table_data.mode2[opcode], (byte)opcode);
        }
        for (opcode = 0; opcode < 256; ++opcode) {
            short single_opcode;
            if (code_table_data.inst1[opcode] == 0 || code_table_data.inst2[opcode] == 0 || (single_opcode = this.LookupFirstOpcode(code_table_data.inst1[opcode], code_table_data.size1[opcode], code_table_data.mode1[opcode])) == 256) continue;
            this.second_instruction_map_.Add((byte)single_opcode, code_table_data.inst2[opcode], code_table_data.size2[opcode], code_table_data.mode2[opcode], (byte)opcode);
        }
    }

    public short LookupFirstOpcode(byte inst, byte size, byte mode) {
        return this.first_instruction_map_.Lookup(inst, size, mode);
    }

    public short LookupSecondOpcode(byte first_opcode, byte inst, byte size, byte mode) {
        return this.second_instruction_map_.Lookup(first_opcode, inst, size, mode);
    }

    private static int FindMaxSize(byte[] size_array) {
        int max_size = size_array[0] & 0xFF;
        for (int i2 = 1; i2 < size_array.length; ++i2) {
            if ((size_array[i2] & 0xFF) <= max_size) continue;
            max_size = size_array[i2] & 0xFF;
        }
        return max_size;
    }

    private static class SecondInstructionMap {
        private final int num_instruction_type_modes_;
        private final int max_size_2_;
        private final short[][][] second_opcodes_ = new short[256][][];

        public SecondInstructionMap(int num_insts_and_modes, int max_size_2) {
            this.num_instruction_type_modes_ = num_insts_and_modes;
            this.max_size_2_ = max_size_2;
        }

        public void Add(byte first_opcode, byte inst, byte size, byte mode, byte second_opcode) {
            if (this.second_opcodes_[first_opcode & 0xFF] == null) {
                this.second_opcodes_[first_opcode & 0xFF] = new short[this.num_instruction_type_modes_][];
            }
            if (this.second_opcodes_[first_opcode & 0xFF][(inst & 0xFF) + (mode & 0xFF)] == null) {
                this.second_opcodes_[first_opcode & 0xFF][(inst & 0xFF) + (mode & 0xFF)] = new short[this.max_size_2_ + 1];
                Arrays.fill(this.second_opcodes_[first_opcode & 0xFF][(inst & 0xFF) + (mode & 0xFF)], (short)256);
            }
            if (this.second_opcodes_[first_opcode & 0xFF][(inst & 0xFF) + (mode & 0xFF)][size & 0xFF] == 256) {
                this.second_opcodes_[first_opcode & 0xFF][(inst & 0xFF) + (mode & 0xFF)][size & 0xFF] = (short)(second_opcode & 0xFF);
            }
        }

        public short Lookup(byte first_opcode, byte inst, byte size, byte mode) {
            int inst_mode;
            if ((size & 0xFF) > this.max_size_2_) {
                return 256;
            }
            if (this.second_opcodes_[first_opcode & 0xFF] == null) {
                return 256;
            }
            int n2 = inst_mode = inst == 3 ? (inst & 0xFF) + (mode & 0xFF) : inst & 0xFF;
            if (this.second_opcodes_[first_opcode & 0xFF][inst_mode] == null) {
                return 256;
            }
            return this.second_opcodes_[first_opcode & 0xFF][inst_mode][size & 0xFF];
        }
    }

    private static class FirstInstructionMap {
        private final int num_instruction_type_modes_;
        private final int max_size_1_;
        private final short[][] first_opcodes_;

        public FirstInstructionMap(int num_insts_and_modes, int max_size_1) {
            this.num_instruction_type_modes_ = num_insts_and_modes;
            this.max_size_1_ = max_size_1;
            for (short[] array : this.first_opcodes_ = new short[this.num_instruction_type_modes_][max_size_1 + 1]) {
                Arrays.fill(array, (short)256);
            }
        }

        public void Add(byte inst, byte size, byte mode, byte opcode) {
            if (this.first_opcodes_[(inst & 0xFF) + (mode & 0xFF)][size & 0xFF] == 256) {
                this.first_opcodes_[(inst & 0xFF) + (mode & 0xFF)][size & 0xFF] = (short)(opcode & 0xFF);
            }
        }

        public short Lookup(byte inst, byte size, byte mode) {
            int inst_mode;
            int n2 = inst_mode = inst == 3 ? (inst & 0xFF) + (mode & 0xFF) : inst & 0xFF;
            if ((size & 0xFF) > this.max_size_1_) {
                return 256;
            }
            return this.first_opcodes_[inst_mode][size & 0xFF];
        }
    }
}

